/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.jira.setting.JiraSetting;
import com.pmease.quickbuild.setting.configuration.version.VersionManager;

@Editable(name="Use first unreleased version of associated JIRA project")
public class JiraVersionManager
extends VersionManager {
    private static final long serialVersionUID = 1L;
    private String pattern;

    @Editable(name="Version Pattern", description="If this property is specified, the first unreleased version matching this <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">pattern</a> will be used as next build version. For example, the pattern \"2\\.0\\..*\" (period character is escaped since it has special meaning in Java pattern) tells QuickBuild to use first unreleased version starting with \"2.0\".")
    @Scriptable
    @ScriptApi(value="Get pattern of unreleased versions.")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getNext() {
        JiraSetting setting = JiraSetting.get(Context.getConfiguration());
        return setting.getNextUnreleasedVersion(this.getPattern());
    }
}

