/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.jira.JiraIssue;
import com.pmease.quickbuild.plugin.tracker.jira.JiraPlugin;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.setting.JiraSetting;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.common.soap.jira.AbstractNamedRemoteEntity;
import org.swift.common.soap.jira.RemoteIssue;
import org.swift.common.soap.jira.RemoteIssueType;
import org.swift.common.soap.jira.RemotePriority;
import org.swift.common.soap.jira.RemoteResolution;
import org.swift.common.soap.jira.RemoteStatus;

public class JiraTracker
extends AbstractIssueTracker {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JiraTracker.class);

    protected Class<? extends AbstractTrackerPlugin> getTrackerPluginClass() {
        return JiraPlugin.class;
    }

    public Map<String, Issue> fetchIssues(JiraClient client, Collection<String> keys, RemotePriority[] priorities, RemoteStatus[] statuses, RemoteResolution[] resolutions, RemoteIssueType[] types) {
        if (logger.isDebugEnabled()) {
            logger.debug("Trying to fetch issues ...");
        }
        LinkedHashMap<String, Issue> issues = new LinkedHashMap<String, Issue>();
        for (String key : keys) {
            Issue issue = new Issue();
            issue.setIssueKey(key);
            RemoteIssue remoteIssue = client.getNullableIssue(key);
            if (remoteIssue == null) continue;
            issues.put(key, this.remoteIssueToJiraIssue(remoteIssue, statuses, priorities, resolutions, types));
        }
        return issues;
    }

    public String getIssueUrlPattern() {
        JiraSetting server = JiraSetting.get(Context.getConfiguration());
        return StringHelper.normalizeUrl((String)server.getHost()) + "/browse/$KEY";
    }

    public Pattern getIssuePattern() {
        String s = new StringBuffer("\\b").append(JiraSetting.get(Context.getConfiguration()).getIssuePattern()).append("\\b").toString();
        return Pattern.compile(s);
    }

    private JiraIssue remoteIssueToJiraIssue(RemoteIssue issue, RemoteStatus[] statuses, RemotePriority[] priorities, RemoteResolution[] resolutions, RemoteIssueType[] types) {
        JiraIssue ji = new JiraIssue(issue);
        int index = JiraClient.findEntityIndex(ji.getStatus(), (AbstractNamedRemoteEntity[])statuses);
        if (index >= 0) {
            ji.setStatus(statuses[index].getName());
        }
        if ((index = JiraClient.findEntityIndex(ji.getPriority(), (AbstractNamedRemoteEntity[])priorities)) >= 0) {
            ji.setPriority(priorities[index].getName());
        }
        if ((index = JiraClient.findEntityIndex(ji.getResolution(), (AbstractNamedRemoteEntity[])resolutions)) >= 0) {
            ji.setResolution(resolutions[index].getName());
        }
        if ((index = JiraClient.findEntityIndex(ji.getIssueType(), (AbstractNamedRemoteEntity[])types)) >= 0) {
            ji.setIssueType(types[index].getName());
        }
        return ji;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Issue> fetchIssues(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        JiraClient client = null;
        try {
            client = JiraClient.newInstance();
            RemotePriority[] priorities = client.getPriorities();
            RemoteStatus[] statuses = client.getStatuses();
            RemoteResolution[] resolutions = client.getResolutions();
            RemoteIssueType[] types = client.getIssueTypes();
            Map<String, Issue> map = this.fetchIssues(client, keys, priorities, statuses, resolutions, types);
            return map;
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }
}

