/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.extensionpoint.AuthenticatorProvider;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.VersionManagerProvider;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.IssueCategory;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.plugin.tracker.jira.JiraAuthenticator;
import com.pmease.quickbuild.plugin.tracker.jira.JiraCategory;
import com.pmease.quickbuild.plugin.tracker.jira.JiraTracker;
import com.pmease.quickbuild.plugin.tracker.jira.JiraVersionManager;
import com.pmease.quickbuild.plugin.tracker.jira.gadget.JiraGadget;
import com.pmease.quickbuild.plugin.tracker.jira.rest.JiraRestResource;
import com.pmease.quickbuild.plugin.tracker.jira.setting.JiraSetting;
import com.pmease.quickbuild.plugin.tracker.jira.setting.JiraUserSetting;
import com.pmease.quickbuild.plugin.tracker.jira.step.CreateIssueStep;
import com.pmease.quickbuild.plugin.tracker.jira.step.ReleaseNotesStep;
import com.pmease.quickbuild.plugin.tracker.jira.step.ReleaseVersionStep;
import com.pmease.quickbuild.plugin.tracker.jira.step.UpdateIssueStep;
import com.pmease.quickbuild.security.Authenticator;
import com.pmease.quickbuild.setting.configuration.version.VersionManager;
import com.pmease.quickbuild.stepsupport.Step;
import org.apache.commons.lang.StringUtils;

public class JiraPlugin
extends AbstractTrackerPlugin {
    protected Class<?>[] getRestResourceClasses() {
        return new Class[]{JiraRestResource.class};
    }

    public IssueTracker createTracker() {
        return new JiraTracker();
    }

    private static boolean isApplicable() {
        JiraSetting setting = JiraSetting.get(Context.getConfiguration());
        if (setting == null) {
            return false;
        }
        return !StringUtils.isEmpty((String)setting.getAssociatedProject());
    }

    protected Object[] getExtraExtensions() {
        return new Object[]{new AuthenticatorProvider(){

            public Class<? extends Authenticator> getAuthenticatorClass() {
                return JiraAuthenticator.class;
            }
        }, new StepProvider(){

            public Class<? extends Step> getStepClass() {
                if (JiraPlugin.isApplicable()) {
                    return CreateIssueStep.class;
                }
                return null;
            }
        }, new StepProvider(){

            public Class<? extends Step> getStepClass() {
                if (JiraPlugin.isApplicable()) {
                    return UpdateIssueStep.class;
                }
                return null;
            }
        }, new StepProvider(){

            public Class<? extends Step> getStepClass() {
                if (JiraPlugin.isApplicable()) {
                    return ReleaseVersionStep.class;
                }
                return null;
            }
        }, new StepProvider(){

            public Class<? extends Step> getStepClass() {
                if (JiraPlugin.isApplicable()) {
                    return ReleaseNotesStep.class;
                }
                return null;
            }
        }, new VersionManagerProvider(){

            public Class<? extends VersionManager> getVersionManagerClass() {
                if (JiraPlugin.isApplicable()) {
                    return JiraVersionManager.class;
                }
                return null;
            }
        }};
    }

    protected Class<? extends Gadget>[] getGadgetClasses() {
        return new Class[]{JiraGadget.class};
    }

    public Class<?> getConfigurationSettingClass() {
        return JiraSetting.class;
    }

    public Class<?> getUserSettingClass() {
        return JiraUserSetting.class;
    }

    protected IssueCategory createCategory() {
        return new JiraCategory();
    }

    @ScriptApi(value="Get the JIRA settings which is defined in the configuration.")
    public JiraSetting getJiraServer(Configuration configuration) {
        return JiraSetting.get(configuration);
    }
}

