/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira;

import com.google.common.collect.Sets;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.swift.common.soap.jira.AbstractNamedRemoteEntity;
import org.swift.common.soap.jira.RemoteCustomFieldValue;
import org.swift.common.soap.jira.RemoteIssue;
import org.swift.common.soap.jira.RemoteIssueType;
import org.swift.common.soap.jira.RemotePriority;
import org.swift.common.soap.jira.RemoteResolution;
import org.swift.common.soap.jira.RemoteStatus;
import org.swift.common.soap.jira.RemoteVersion;

public class JiraIssue
extends Issue {
    private static final long serialVersionUID = 1L;
    private transient RemoteIssue remoteIssue;

    public JiraIssue(RemoteIssue remoteIssue) {
        this.setIssueKey(remoteIssue.getKey());
        this.setAssignee(remoteIssue.getAssignee());
        Calendar cal = remoteIssue.getCreated();
        if (cal != null) {
            this.setCreated(cal);
        }
        if ((cal = remoteIssue.getUpdated()) != null) {
            this.setUpdated(cal);
        }
        this.setIssueType(remoteIssue.getType());
        this.setPriority(remoteIssue.getPriority());
        this.setReporter(remoteIssue.getReporter());
        this.setResolution(remoteIssue.getResolution());
        this.setStatus(remoteIssue.getStatus());
        this.setSummary(remoteIssue.getSummary());
        this.remoteIssue = remoteIssue;
    }

    public static JiraIssue of(RemoteIssue issue, RemoteStatus[] statuses, RemotePriority[] priorities, RemoteResolution[] resolutions, RemoteIssueType[] types) {
        JiraIssue ji = new JiraIssue(issue);
        int index = JiraClient.findEntityIndex(ji.getStatus(), (AbstractNamedRemoteEntity[])statuses);
        if (index >= 0) {
            ji.setStatus(statuses[index].getName());
        }
        if ((index = JiraClient.findEntityIndex(ji.getPriority(), (AbstractNamedRemoteEntity[])priorities)) >= 0) {
            ji.setPriority(priorities[index].getName());
        }
        if ((index = JiraClient.findEntityIndex(ji.getResolution(), (AbstractNamedRemoteEntity[])resolutions)) >= 0) {
            ji.setResolution(resolutions[index].getName());
        }
        if ((index = JiraClient.findEntityIndex(ji.getIssueType(), (AbstractNamedRemoteEntity[])types)) >= 0) {
            ji.setIssueType(types[index].getName());
        }
        return ji;
    }

    public RemoteCustomFieldValue[] getCustomValues() {
        return this.remoteIssue.getCustomFieldValues();
    }

    public RemoteIssue getRemoteIssue() {
        return this.remoteIssue;
    }

    public Set<String> getFixVersions() {
        RemoteVersion[] versions = this.remoteIssue.getFixVersions();
        HashSet v = Sets.newHashSet();
        for (RemoteVersion each : versions) {
            v.add(each.getName());
        }
        return v;
    }

    public Set<String> getAffectsVersions() {
        RemoteVersion[] versions = this.remoteIssue.getAffectsVersions();
        HashSet v = Sets.newHashSet();
        for (RemoteVersion each : versions) {
            v.add(each.getName());
        }
        return v;
    }
}

