/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.security.AuthenticationResult;
import com.pmease.quickbuild.security.Authenticator;
import org.hibernate.validator.constraints.NotEmpty;
import org.swift.common.soap.jira.RemoteUser;

@Editable(name="JIRA")
public class JiraAuthenticator
extends Authenticator {
    private static final long serialVersionUID = 1L;
    private String url;

    public AuthenticationResult authenticate(String userName, String password) {
        if (password == null) {
            return null;
        }
        JiraClient client = new JiraClient(this.getUrl(), userName, password);
        try {
            client.setupRemote();
            RemoteUser user = client.getMyself();
            AuthenticationResult result = new AuthenticationResult();
            result.setEmail(user.getEmail());
            result.setFullName(user.getFullname());
            return result;
        }
        catch (TrackerException e) {
            return null;
        }
    }

    @Editable(name="JIRA URL", order=100, description="Specifies the URL of JIRA instance")
    @NotEmpty
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

