/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.authenticator.ldap;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.authenticator.ldap.GetGroupsUsingAttribute;
import com.pmease.quickbuild.plugin.authenticator.ldap.GroupRetrievalStrategy;
import com.pmease.quickbuild.plugin.authenticator.ldap.SearchGroupsUsingFilter;
import com.pmease.quickbuild.security.AuthenticationResult;
import com.pmease.quickbuild.security.Authenticator;
import com.pmease.quickbuild.security.TrustAllSSLSocketFactory;
import com.pmease.quickbuild.util.StringUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;
import javax.naming.AuthenticationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Editable(name="LDAP", order=200)
public class LdapAuthenticator
extends Authenticator {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(LdapAuthenticator.class);
    private String ldapUrl;
    private boolean followReferrals = true;
    private String bindUser;
    private String bindPassword;
    private String userSearchBase;
    private String userSearchFilter;
    private String userFullNameAttribute;
    private String userEmailAttribute;
    private GroupRetrievalStrategy groupRetrievalStrategy;

    @Editable(order=100, name="LDAP URL", description="Specifies LDAP URL, for example: <b>ldap://localhost:389</b>, or <b>ldaps://localhost:636</b>.")
    @NotEmpty
    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    @Editable(order=200, description="Specifies whether or not to follow referrals when search in this LDAP server. Consult your LDAP administrator for detail information about referral. Leave it as checked is approriate for most cases.")
    public boolean isFollowReferrals() {
        return this.followReferrals;
    }

    public void setFollowReferrals(boolean followReferrals) {
        this.followReferrals = followReferrals;
    }

    @Editable(order=300, description="Specifies the binding user DN in order to perform LDAP searches. If this property is left as empty, QuickBuild will try to bind anonymously to perform LDAP searches.<br><strong>NOTE:</strong> <b>{0}</b> contained in this property will be replaced by name of the login user.")
    public String getBindUser() {
        return this.bindUser;
    }

    public void setBindUser(String bindUser) {
        this.bindUser = bindUser;
    }

    @Editable(order=400, description="Specifies password in order to bind as above DN.<br><strong>NOTE:</strong> To specify password of the login user, just use <b>{0}</b>.")
    @Password
    public String getBindPassword() {
        return this.bindPassword;
    }

    public void setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword;
    }

    @Editable(order=500, description="Specifies the base node for user search. For example: <b>ou=users, dc=example, dc=com</b>")
    @NotEmpty
    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    @Editable(order=600, description="This filter is used to determine the LDAP entry for current user. For example: <b>(&(uid={0})(objectclass=person))</b>. In this example, <b>{0}</b> represents login name of current user.")
    @NotEmpty
    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    @Editable(order=700, description="Optionally specifies name of the attribute inside the user entry whose value will be taken as user full name. If left empty, full name of the user will not be retrieved.")
    public String getUserFullNameAttribute() {
        return this.userFullNameAttribute;
    }

    public void setUserFullNameAttribute(String userFullNameAttribute) {
        this.userFullNameAttribute = userFullNameAttribute;
    }

    @Editable(order=800, description="Specifies name of the attribute inside the user entry whose value will be taken as user email. If left empty, email of the user will not be retrieved. ")
    public String getUserEmailAttribute() {
        return this.userEmailAttribute;
    }

    public void setUserEmailAttribute(String userEmailAttribute) {
        this.userEmailAttribute = userEmailAttribute;
    }

    @Editable(order=900, description="Specify group retrieval strategy here. QuickBuild tries to get groups associated with authenticated user and map them to QuickBuild groups to determine user permission. If group information is not retrieved, the default group will be used to associate with authenticated users.")
    @NotNull
    public GroupRetrievalStrategy getGroupRetrievalStrategy() {
        return this.groupRetrievalStrategy;
    }

    public void setGroupRetrievalStrategy(GroupRetrievalStrategy groupRetrievalStrategy) {
        this.groupRetrievalStrategy = groupRetrievalStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthenticationResult authenticate(String userName, String password) {
        GroupRetrievalStrategy strategy;
        Attributes searchResultAttributes;
        Context userCtx;
        NamingEnumeration<SearchResult> results;
        Context referralCtx;
        Context ctx;
        String evaluatedBindUser;
        Hashtable<String, String> ldapEnv;
        SearchControls searchControls;
        AuthenticationResult result;
        block95: {
            block94: {
                Name userSearchBase;
                if (password == null) {
                    if (this.getBindUser() != null) {
                        if (this.getBindUser().contains("{0}")) throw new QuickbuildException("Can only retrieve user info if LDAP authenticator is configured to bind as a separate account.");
                    }
                    if (this.getBindPassword() != null && this.getBindPassword().contains("{0}")) {
                        throw new QuickbuildException("Can only retrieve user info if LDAP authenticator is configured to bind as a separate account.");
                    }
                }
                result = new AuthenticationResult();
                try {
                    userSearchBase = new CompositeName().add(this.getUserSearchBase());
                }
                catch (InvalidNameException e) {
                    throw new RuntimeException(e);
                }
                String userSearchFilter = StringUtils.replace((String)this.getUserSearchFilter(), (String)"{0}", (String)userName);
                userSearchFilter = StringUtils.replace((String)userSearchFilter, (String)"\\", (String)"\\\\");
                logger.debug("Evaluated user search filter: " + userSearchFilter);
                searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                ArrayList<String> attributeNames = new ArrayList<String>();
                if (this.getUserFullNameAttribute() != null) {
                    attributeNames.add(this.getUserFullNameAttribute());
                }
                if (this.getUserEmailAttribute() != null) {
                    attributeNames.add(this.getUserEmailAttribute());
                }
                if (this.getGroupRetrievalStrategy() instanceof GetGroupsUsingAttribute) {
                    GetGroupsUsingAttribute strategy2 = (GetGroupsUsingAttribute)this.getGroupRetrievalStrategy();
                    attributeNames.add(strategy2.getUserGroupsAttribute());
                }
                searchControls.setReturningAttributes(attributeNames.toArray(new String[0]));
                searchControls.setReturningObjFlag(true);
                ldapEnv = new Hashtable<String, String>();
                ldapEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                ldapEnv.put("java.naming.provider.url", this.getLdapUrl());
                ldapEnv.put("java.naming.security.authentication", "simple");
                ldapEnv.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(120000L));
                ldapEnv.put("com.sun.jndi.ldap.read.timeout", String.valueOf(300000L));
                if (this.getLdapUrl().startsWith("ldaps")) {
                    ldapEnv.put("java.naming.ldap.factory.socket", TrustAllSSLSocketFactory.class.getName());
                }
                if (this.isFollowReferrals()) {
                    ldapEnv.put("java.naming.referral", "follow");
                } else {
                    ldapEnv.put("java.naming.referral", "ignore");
                }
                evaluatedBindUser = null;
                String evaluatedBindPassword = null;
                if (this.getBindUser() != null) {
                    evaluatedBindUser = StringUtils.replace((String)this.getBindUser(), (String)"{0}", (String)userName);
                }
                if (this.getBindPassword() != null) {
                    evaluatedBindPassword = StringUtils.replace((String)this.getBindPassword(), (String)"{0}", (String)password);
                }
                if (evaluatedBindUser != null) {
                    ldapEnv.put("java.naming.security.principal", evaluatedBindUser);
                }
                if (evaluatedBindPassword != null) {
                    ldapEnv.put("java.naming.security.credentials", evaluatedBindPassword);
                }
                ctx = null;
                referralCtx = null;
                try {
                    if (evaluatedBindUser != null) {
                        logger.debug("Binding to ldap url '" + this.getLdapUrl() + "' as '" + evaluatedBindUser + "'...");
                    } else {
                        logger.debug("Binding to ldap url '" + this.getLdapUrl() + "' anonymously...");
                    }
                    try {
                        ctx = new InitialDirContext(ldapEnv);
                    }
                    catch (AuthenticationException e) {
                        if (this.getBindUser() == null) throw new QuickbuildException("Can not bind to ldap server '" + this.getLdapUrl() + "' as user '" + this.getBindUser() + "': " + e.getMessage());
                        if (!this.getBindUser().contains("{0}")) throw new QuickbuildException("Can not bind to ldap server '" + this.getLdapUrl() + "' as user '" + this.getBindUser() + "': " + e.getMessage());
                        logger.debug("Error authenticating user.", (Throwable)e);
                        AuthenticationResult authenticationResult = null;
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (NamingException e2) {
                                // empty catch block
                            }
                        }
                        if (referralCtx == null) return authenticationResult;
                        try {
                            referralCtx.close();
                            return authenticationResult;
                        }
                        catch (NamingException e3) {
                            // empty catch block
                        }
                        return authenticationResult;
                    }
                    results = ctx.search(userSearchBase, userSearchFilter, searchControls);
                    if (results == null) break block94;
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
                if (results.hasMore()) break block95;
            }
            logger.debug("User search returns no result.");
            return null;
        }
        SearchResult searchResult = results.next();
        String userDN = searchResult.getNameInNamespace();
        if (!searchResult.isRelative()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(StringUtils.substringBefore((String)searchResult.getName(), (String)"//"));
            buffer.append("//");
            buffer.append(StringUtils.substringBefore((String)StringUtils.substringAfter((String)searchResult.getName(), (String)"//"), (String)"/"));
            ldapEnv.put("java.naming.provider.url", buffer.toString());
            if (evaluatedBindUser != null) {
                logger.debug("Binding to referral ldap url '" + buffer.toString() + "' as '" + evaluatedBindUser + "'...");
            } else {
                logger.debug("Binding to referral ldap url '" + buffer.toString() + "' anonymously...");
            }
            referralCtx = new InitialDirContext(ldapEnv);
        }
        if (userDN.startsWith("ldap")) {
            userDN = StringUtils.substringAfter((String)userDN, (String)"//");
            userDN = StringUtils.substringAfter((String)userDN, (String)"/");
        }
        if (password != null && !StringUtils.contains((String)this.getBindUser(), (String)"{0}")) {
            ldapEnv.put("java.naming.security.principal", userDN);
            ldapEnv.put("java.naming.security.credentials", password);
            userCtx = null;
            try {
                logger.debug("Authenticating user by binding as '" + userDN + "'...");
                userCtx = new InitialDirContext(ldapEnv);
            }
            catch (AuthenticationException e) {
                logger.debug("Error authenticating user.", (Throwable)e);
                AuthenticationResult authenticationResult = null;
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException e4) {
                        // empty catch block
                    }
                }
                if (referralCtx == null) return authenticationResult;
                try {
                    referralCtx.close();
                    return authenticationResult;
                }
                catch (NamingException e5) {
                    // empty catch block
                }
                return authenticationResult;
            }
        }
        if ((searchResultAttributes = searchResult.getAttributes()) != null) {
            Attribute attribute;
            if (this.getUserFullNameAttribute() != null && (attribute = searchResultAttributes.get(this.getUserFullNameAttribute())) != null && attribute.get() != null) {
                result.setFullName((String)attribute.get());
            }
            if (this.getUserEmailAttribute() != null && (attribute = searchResultAttributes.get(this.getUserEmailAttribute())) != null && attribute.get() != null) {
                result.setEmail((String)attribute.get());
            }
            if (this.getGroupRetrievalStrategy() instanceof GetGroupsUsingAttribute) {
                strategy = (GetGroupsUsingAttribute)this.getGroupRetrievalStrategy();
                Attribute attribute2 = searchResultAttributes.get(((GetGroupsUsingAttribute)strategy).getUserGroupsAttribute());
                if (attribute2 != null) {
                    NamingEnumeration<?> e = attribute2.getAll();
                    while (e.hasMore()) {
                        Name groupDN = new CompositeName().add((String)e.next());
                        logger.debug("Looking up group entry '" + groupDN + "'...");
                        DirContext groupCtx = null;
                        try {
                            groupCtx = referralCtx != null ? (DirContext)referralCtx.lookup(groupDN) : (DirContext)ctx.lookup(groupDN);
                            if (groupCtx == null) {
                                throw new QuickbuildException("Can not find group entry identified by '" + groupDN + "'.");
                            }
                            String groupNameAttribute = strategy.getGroupNameAttribute();
                            Attributes groupAttributes = groupCtx.getAttributes("", new String[]{groupNameAttribute});
                            if (groupAttributes == null) throw new QuickbuildException("Can not find attribute '" + groupNameAttribute + "' in returned group entry.");
                            if (groupAttributes.get(groupNameAttribute) == null) throw new QuickbuildException("Can not find attribute '" + groupNameAttribute + "' in returned group entry.");
                            if (groupAttributes.get(groupNameAttribute).get() == null) {
                                throw new QuickbuildException("Can not find attribute '" + groupNameAttribute + "' in returned group entry.");
                            }
                            result.getGroupNames().add((String)groupAttributes.get(groupNameAttribute).get());
                        }
                        catch (PartialResultException pre) {
                            throw new QuickbuildException("Partial exception detected. You may try to set property 'follow referrals' to true to avoid this exception.", (Throwable)pre);
                        }
                        finally {
                            if (groupCtx == null) continue;
                            try {
                                groupCtx.close();
                            }
                            catch (NamingException ne) {}
                        }
                    }
                } else {
                    logger.warn("No attribute identified by '" + ((GetGroupsUsingAttribute)strategy).getUserGroupsAttribute() + "' inside fetched user entry.");
                }
            }
        }
        if (!(this.getGroupRetrievalStrategy() instanceof SearchGroupsUsingFilter)) return result;
        strategy = (SearchGroupsUsingFilter)this.getGroupRetrievalStrategy();
        String groupNameAttribute = strategy.getGroupNameAttribute();
        Name groupSearchBase = new CompositeName().add(((SearchGroupsUsingFilter)strategy).getGroupSearchBase());
        String groupSearchFilter = StringUtils.replace((String)((SearchGroupsUsingFilter)strategy).getGroupSearchFilter(), (String)"{0}", (String)userDN);
        groupSearchFilter = StringUtils.replace((String)groupSearchFilter, (String)"\\", (String)"\\\\");
        logger.debug("Evaluated group search filter: " + groupSearchFilter);
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{groupNameAttribute});
        try {
            results = referralCtx != null ? referralCtx.search(groupSearchBase, groupSearchFilter, searchControls) : ctx.search(groupSearchBase, groupSearchFilter, searchControls);
            if (results == null) return result;
            while (results.hasMore()) {
                searchResult = results.next();
                searchResultAttributes = searchResult.getAttributes();
                if (searchResultAttributes == null) throw new QuickbuildException("Can not find attribute '" + groupNameAttribute + "' in the returned group object.");
                if (searchResultAttributes.get(groupNameAttribute) == null) throw new QuickbuildException("Can not find attribute '" + groupNameAttribute + "' in the returned group object.");
                if (searchResultAttributes.get(groupNameAttribute).get() == null) {
                    throw new QuickbuildException("Can not find attribute '" + groupNameAttribute + "' in the returned group object.");
                }
                result.getGroupNames().add((String)searchResultAttributes.get(groupNameAttribute).get());
            }
            return result;
        }
        catch (PartialResultException pre) {
            logger.warn("Partial exception detected. You may try to set property 'follow referrals' to true to avoid this exception.", (Throwable)pre);
        }
        return result;
        finally {
            if (userCtx != null) {
                try {
                    userCtx.close();
                }
                catch (NamingException e) {}
            }
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
            }
            if (referralCtx != null) {
                try {
                    referralCtx.close();
                }
                catch (NamingException e) {}
            }
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }
}

