/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.cvs;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.cvs.CvsRepository;
import com.pmease.quickbuild.plugin.scm.cvs.CvsRevision;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class CvsSourceViewSupport
extends SourceViewSupport<CvsRevision> {
    public CvsSourceViewSupport(CvsRepository repository) {
        super((Repository)repository);
    }

    public CvsRepository getRepository() {
        return (CvsRepository)super.getRepository();
    }

    public String getRepositoryPath(String checkoutPath) {
        String relativePath;
        try {
            File checkoutFile = new File(Context.getConfiguration().getWorkspaceDir(), checkoutPath);
            relativePath = FileUtils.getRelativePath((String)checkoutFile.getCanonicalPath(), (String)this.getRepository().getDestDir().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (relativePath == null) {
            return null;
        }
        for (String module : this.getRepository().listModules()) {
            if (FileUtils.getRelativePath((String)relativePath, (String)module) == null) continue;
            return StringUtils.stripStart((String)relativePath, (String)"/");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFile(String repositoryPath, List<String> versionArgs) {
        File passwdFile = this.getRepository().createPasswdFile(this.getRepository().getCvsPassword());
        try {
            List<String> list;
            block12: {
                File destDir;
                block10: {
                    List list2;
                    block11: {
                        Commandline cmdline = this.getRepository().buildCvsCmd(this.getRepository().getCvsRoot());
                        cmdline.addArgValue("co");
                        for (String arg : versionArgs) {
                            cmdline.addArgValue(arg);
                        }
                        destDir = new File(Bootstrap.getTempDir(), UUID.randomUUID().toString());
                        cmdline.addArgValue("-d").addArgValue(destDir.getName()).addArgValue(repositoryPath);
                        try {
                            cmdline.execute(destDir.getParentFile(), this.getRepository().createPasswdEnv(passwdFile), (OutputStream)new LineConsumer.InfoLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
                            String fileName = StringUtils.substringAfterLast((String)repositoryPath, (String)"/");
                            File file = new File(destDir, fileName);
                            if (!file.exists() || !file.isFile()) break block10;
                            list2 = FileUtils.readFileAsLines((File)file);
                            if (!destDir.exists()) break block11;
                        }
                        catch (Throwable throwable) {
                            if (destDir.exists()) {
                                FileUtils.deleteDir((File)destDir);
                            }
                            throw throwable;
                        }
                        FileUtils.deleteDir((File)destDir);
                    }
                    return list2;
                }
                list = null;
                if (!destDir.exists()) break block12;
                FileUtils.deleteDir((File)destDir);
            }
            return list;
        }
        finally {
            FileUtils.deleteFile((File)passwdFile);
        }
    }

    public List<String> readSourceByRevision(String repositoryPath, CvsRevision revision) {
        ArrayList<String> versionArgs = new ArrayList<String>();
        if (revision.getTag() != null) {
            versionArgs.add("-r");
            versionArgs.add(revision.getTag());
        } else {
            if (this.getRepository().getBranch() != null) {
                versionArgs.add("-r");
                versionArgs.add(this.getRepository().getBranch());
            }
            versionArgs.add("-D");
            versionArgs.add(this.getRepository().getInputDateTimeFormatter().print((ReadableInstant)new DateTime((Object)revision.getDate())));
        }
        return this.readFile(repositoryPath, versionArgs);
    }

    public List<String> readSourceByEdition(String repositoryPath, String edition) {
        return this.readFile(repositoryPath, Arrays.asList("-r", edition));
    }
}

