/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.cvs;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.scm.cvs.CvsPlugin;
import com.pmease.quickbuild.plugin.scm.cvs.CvsProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.cvs.CvsRevision;
import com.pmease.quickbuild.plugin.scm.cvs.CvsSetting;
import com.pmease.quickbuild.plugin.scm.cvs.CvsSourceViewSupport;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.FlatChange;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;
import org.apache.tools.ant.types.Environment;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Editable(name="CVS", description="Configure a CVS repository here. By default, QuickBuild executes \"cvs\" to checkout from the repository, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the CVS plugin through the plugin management page. Please note that QuickBuild does not work with cvs versions older than or equals to 1.11.1.")
@ScriptApi
public class CvsRepository
extends Repository<CvsRevision>
implements Validatable {
    private static final long serialVersionUID = 1L;
    private static final char[] PASSWORD_SHIFTS = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', 'r', 'x', '5', 'O', '`', 'm', 'H', 'l', 'F', '@', 'L', 'C', 't', 'J', 'D', 'W', 'o', '4', 'K', 'w', '1', '\"', 'R', 'Q', '_', 'A', 'p', 'V', 'v', 'n', 'z', 'i', ')', '9', 'S', '+', '.', 'f', '(', 'Y', '&', 'g', '-', '2', '*', '{', '[', '#', '}', '7', '6', 'B', '|', '~', ';', '/', '\\', 'G', 's', 'N', 'X', 'k', 'j', '8', '$', 'y', 'u', 'h', 'e', 'd', 'E', 'I', 'c', '?', '^', ']', '\'', '%', '=', '0', ':', 'q', ' ', 'Z', ',', 'b', '<', '3', '!', 'a', '>', 'M', 'T', 'P', 'U', '\u00df', '\u00e1', '\u00d8', '\u00bb', '\u00a6', '\u00e5', '\u00bd', '\u00de', '\u00bc', '\u008d', '\u00f9', '\u0094', '\u00c8', '\u00b8', '\u0088', '\u00f8', '\u00be', '\u00c7', '\u00aa', '\u00b5', '\u00cc', '\u008a', '\u00e8', '\u00da', '\u00b7', '\u00ff', '\u00ea', '\u00dc', '\u00f7', '\u00d5', '\u00cb', '\u00e2', '\u00c1', '\u00ae', '\u00ac', '\u00e4', '\u00fc', '\u00d9', '\u00c9', '\u0083', '\u00e6', '\u00c5', '\u00d3', '\u0091', '\u00ee', '\u00a1', '\u00b3', '\u00a0', '\u00d4', '\u00cf', '\u00dd', '\u00fe', '\u00ad', '\u00ca', '\u0092', '\u00e0', '\u0097', '\u008c', '\u00c4', '\u00cd', '\u0082', '\u0087', '\u0085', '\u008f', '\u00f6', '\u00c0', '\u009f', '\u00f4', '\u00ef', '\u00b9', '\u00a8', '\u00d7', '\u0090', '\u008b', '\u00a5', '\u00b4', '\u009d', '\u0093', '\u00ba', '\u00d6', '\u00b0', '\u00e3', '\u00e7', '\u00db', '\u00a9', '\u00af', '\u009c', '\u00ce', '\u00c6', '\u0081', '\u00a4', '\u0096', '\u00d2', '\u009a', '\u00b1', '\u0086', '\u007f', '\u00b6', '\u0080', '\u009e', '\u00d0', '\u00a2', '\u0084', '\u00a7', '\u00d1', '\u0095', '\u00f1', '\u0099', '\u00fb', '\u00ed', '\u00ec', '\u00ab', '\u00c3', '\u00f3', '\u00e9', '\u00fd', '\u00f0', '\u00c2', '\u00fa', '\u00bf', '\u009b', '\u008e', '\u0089', '\u00f5', '\u00eb', '\u00a3', '\u00f2', '\u00b2', '\u0098'};
    private static final DateTimeFormatter OUTPUT_DATETIME_FORMATTER1 = DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss Z");
    private static final DateTimeFormatter OUTPUT_DATETIME_FORMATTER2 = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss Z");
    static final DateTimeFormatter ENTRY_DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss yyyy Z").withLocale(Locale.US);
    static final String REPOSITORY_INFO_FILE = "CVS/Repository";
    private String cvsRoot;
    private String cvsPassword;
    private String modules;
    private String destPath;
    private String tag;
    private String branch;
    private CvsProofBuildSupport proofBuildSupport;
    private transient DateTimeFormatter inputDateTimeFormatter;

    public CvsRepository() {
        this.setQuietPeriod(60);
    }

    @Editable(name="CVS Root", order=100, description="Specify CVS root for this project, for example, <b>:pserver:robin@localhost:/home/cvsroot</b>")
    @NotEmpty
    @ScriptApi(value="Get CVS root of this repository.")
    @Scriptable
    public String getCvsRoot() {
        return this.cvsRoot;
    }

    public void setCvsRoot(String cvsRoot) {
        this.cvsRoot = cvsRoot;
    }

    @Editable(name="CVS Password", order=200, description="Specify the CVS password for above CVS root if connecting using pserver protocol")
    @Password
    @ScriptApi(value="Get password to access the repository.")
    @Scriptable
    public String getCvsPassword() {
        return this.cvsPassword;
    }

    public void setCvsPassword(String cvsPassword) {
        this.cvsPassword = cvsPassword;
    }

    @Editable(order=210, name="Modules to Checkout", description="Specify modules to checkout from CVS repository. Multiple modules should be separated by comma or new line character, for example: <b>server/src, client/src</b>. Please note that QuickBuild does not work with virtual modules, only real modules can be specified here.")
    @Multiline
    @NotEmpty
    @ScriptApi(value="Get modules to be used for checkout.")
    @Scriptable
    public String getModules() {
        return this.modules;
    }

    public void setModules(String modules) {
        this.modules = modules;
    }

    @Editable(order=215, name="Destination Path", description="Specify the path to which the above module will be checked out. It should be relative to the workspace directory. If left empty, modules will be checked out into the workspace directory.")
    @ScriptApi(value="Get the destination path used to hold checked out code. Null if check out code directly into the workspace directory.")
    @Scriptable
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @Editable(order=230, name="Tag to Checkout", description="Specify tag for the modules to checkout. When left empty, latest version of below branch will be retrieved. If this property is specified, the <b>branch</b> property below should be left empty.")
    @ScriptApi(value="Get tag to checkout.")
    @Scriptable
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Editable(order=220, name="Branch to Checkout", description="Specify branch for the modules to checkout. When left empty, main branch is assumed. If this property is specified, the <b>tag</b> property above should be left empty.")
    @ScriptApi(value="Get branch to checkout.")
    @Scriptable
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Editable(order=240, description="Check this to enable proof build for this repository")
    @ScriptApi(value="Get proof build support object. Null if proof build support is not enabled for this repository.")
    @Advanced
    public CvsProofBuildSupport getProofBuildSupport() {
        return this.proofBuildSupport;
    }

    public void setProofBuildSupport(CvsProofBuildSupport proofBuildSupport) {
        this.proofBuildSupport = proofBuildSupport;
    }

    @ScriptApi(value="Get revision of this repository.")
    public CvsRevision getRevision() {
        return (CvsRevision)super.getRevision();
    }

    DateTimeFormatter getInputDateTimeFormatter() {
        if (this.inputDateTimeFormatter == null) {
            this.inputDateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            Commandline cmdline = this.buildCvsCmd(this.getCvsRoot()).addArgValue("-v");
            cmdline.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    if (line.contains("(CVSNT) 2.5") && !line.contains("(CVSNT) 2.5.03") && !line.contains("(CVSNT) 2.5.02") && !line.contains("(CVSNT) 2.5.01")) {
                        CvsRepository.this.inputDateTimeFormatter = CvsRepository.this.inputDateTimeFormatter.withZone(DateTimeZone.UTC);
                    }
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        }
        return this.inputDateTimeFormatter;
    }

    public File getDestDir() {
        return FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getDestPath());
    }

    private String getRootPath() {
        return "/" + StringUtils.stripEnd((String)StringUtils.substringAfter((String)this.getCvsRoot(), (String)"/"), (String)"/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkoutByRevision(CvsRevision revision) {
        File passwdFile = this.createPasswdFile(this.getCvsPassword());
        try {
            Validate.isTrue((revision.getDate() != null || revision.getTag() != null ? 1 : 0) != 0);
            for (String module : this.listModules()) {
                Commandline cmdline;
                File moduleDir = new File(this.getDestDir(), module);
                File moduleCvsDir = new File(moduleDir, "CVS");
                if (moduleCvsDir.exists() && moduleCvsDir.isDirectory()) {
                    Context.getLogger().info("Updating from CVS (module: {}, revision: {})", (Object)module, (Object)revision);
                    cmdline = this.buildCvsCmd(this.getCvsRoot());
                    if (!Context.getLogger().isInfoEnabled()) {
                        cmdline.addArgValue("-Q");
                    }
                    cmdline.addArgLine("update -P");
                    if (revision.getTag() != null) {
                        cmdline.addArgValue("-r").addArgValue(revision.getTag());
                    } else {
                        if (this.getBranch() != null) {
                            cmdline.addArgValue("-r").addArgValue(this.getBranch());
                        }
                        cmdline.addArgValue("-D").addArgValue(this.getInputDateTimeFormatter().print((ReadableInstant)new DateTime((Object)revision.getDate())));
                    }
                    cmdline.addArgLine("-d -C");
                    cmdline.execute(moduleDir, this.createPasswdEnv(passwdFile), (OutputStream)new LineConsumer.DebugLogger(), new LineConsumer(){

                        public void consume(String line) {
                            if (!line.startsWith("cvs server: Updating")) {
                                Context.getLogger().warn(line);
                            } else {
                                Context.getLogger().debug(line);
                            }
                        }
                    }).checkReturnCode();
                    continue;
                }
                Context.getLogger().info("Checking out from CVS (module: {}, revision: {})", (Object)module, (Object)revision);
                cmdline = this.buildCvsCmd(this.getCvsRoot());
                if (!Context.getLogger().isInfoEnabled()) {
                    cmdline.addArgValue("-Q");
                }
                cmdline.addArgLine("checkout -P");
                if (revision.getTag() != null) {
                    cmdline.addArgValue("-r").addArgValue(revision.getTag());
                } else {
                    if (this.getBranch() != null) {
                        cmdline.addArgValue("-r").addArgValue(this.getBranch());
                    }
                    cmdline.addArgValue("-D").addArgValue(this.getInputDateTimeFormatter().print((ReadableInstant)new DateTime((Object)revision.getDate())));
                }
                cmdline.addArgValue(module);
                FileUtils.createDir((File)this.getDestDir());
                cmdline.execute(this.getDestDir(), this.createPasswdEnv(passwdFile), (OutputStream)new LineConsumer.DebugLogger(), new LineConsumer(){

                    public void consume(String line) {
                        if (!line.startsWith("cvs server: Updating")) {
                            Context.getLogger().warn(line);
                        } else {
                            Context.getLogger().debug(line);
                        }
                    }
                }).checkReturnCode();
            }
        }
        finally {
            FileUtils.deleteFile((File)passwdFile);
        }
    }

    public CvsSetting getCvsSetting() {
        return (CvsSetting)PluginSettingHelper.getSetting(CvsPlugin.class, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Changeset> getChangesBetween(CvsRevision startRevision, CvsRevision endRevision) {
        File passwdFile = this.createPasswdFile(this.getCvsPassword());
        try {
            if (startRevision.getDate() == null || endRevision.getDate() == null) {
                ArrayList<Changeset> arrayList = new ArrayList<Changeset>();
                return arrayList;
            }
            Commandline cmdline = this.buildCvsCmd(this.getCvsRoot());
            cmdline.addArgLine("-q rlog -S -N -d");
            cmdline.addArgValue(this.getInputDateTimeFormatter().print((ReadableInstant)new DateTime((Object)startRevision.getDate())) + "<" + this.getInputDateTimeFormatter().print((ReadableInstant)new DateTime((Object)endRevision.getDate())));
            if (this.getBranch() != null) {
                cmdline.addArgValue("-r" + this.getBranch());
            } else {
                cmdline.addArgValue("-b");
            }
            for (String module : this.listModules()) {
                cmdline.addArgValue(module);
            }
            final ArrayList flatChanges = new ArrayList();
            cmdline.execute(Context.getConfiguration().getWorkspaceDir(), this.createPasswdEnv(passwdFile), (OutputStream)new LineConsumer(){
                private String file;
                private String state;
                private FlatChange change = new FlatChange();

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    if (line.startsWith("RCS file: ") && line.endsWith(",v")) {
                        this.file = line.substring("RCS file: ".length(), line.length() - ",v".length());
                        Validate.isTrue((boolean)this.file.startsWith(CvsRepository.this.getRootPath() + "/"));
                        this.file = this.file.substring((CvsRepository.this.getRootPath() + "/").length());
                    } else if (this.change.getComment() == null) {
                        if (line.startsWith("revision ")) {
                            this.change.setEdition(line.substring("revision ".length()));
                        } else if (line.startsWith("date:")) {
                            String datePart = StringUtils.substringBefore((String)line.substring("date: ".length()), (String)";");
                            if (datePart.indexOf(47) != -1) {
                                this.change.setDate(OUTPUT_DATETIME_FORMATTER1.parseDateTime(datePart + " +0000").toDate());
                            } else {
                                this.change.setDate(OUTPUT_DATETIME_FORMATTER2.parseDateTime(datePart).toDate());
                            }
                            if (line.contains("author: ")) {
                                this.change.setUser(StringUtils.substringBefore((String)StringUtils.substringAfter((String)line, (String)"author: "), (String)";"));
                            }
                            this.state = StringUtils.substringBefore((String)StringUtils.substringAfter((String)line, (String)"state: "), (String)";");
                            if (line.contains("commitid: ")) {
                                this.change.setChangesetId(StringUtils.substringBefore((String)StringUtils.substringAfter((String)line, (String)"commitid: "), (String)";"));
                            }
                            this.change.setComment("");
                        }
                    } else if (line.equals("no message") || line.equals("*** empty log message ***") || line.equals("----------------------------") || line.equals("=============================================================================")) {
                        int lastRevisionDigit = Integer.parseInt(StringUtils.substringAfterLast((String)this.change.getEdition(), (String)"."));
                        if (--lastRevisionDigit != 0) {
                            this.change.setPreviousEdition(StringUtils.substringBeforeLast((String)this.change.getEdition(), (String)".") + "." + lastRevisionDigit);
                        }
                        if ("dead".equals(this.state)) {
                            this.change.setAction(Modification.Action.DELETE);
                        } else if (this.change.getPreviousEdition() == null) {
                            this.change.setAction(Modification.Action.ADD);
                        } else {
                            this.change.setAction(Modification.Action.MODIFY);
                        }
                        if (StringUtils.isNotBlank((String)this.file)) {
                            this.change.setPath(this.file);
                            flatChanges.add(this.change);
                        }
                        this.change = new FlatChange();
                    } else if (!(line.startsWith("Committed on the Free edition of March Hare") || line.startsWith("Upgrade to CVS Suite for more features") || line.startsWith("http://march-hare.com/cvsnt"))) {
                        this.change.appendCommentLine(line);
                    }
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            List list = FlatChange.aggregate(flatChanges);
            return list;
        }
        finally {
            FileUtils.deleteFile((File)passwdFile);
        }
    }

    Commandline buildCvsCmd(String cvsRoot) {
        Commandline cmdLine = new Commandline();
        String cvsExe = this.getCvsSetting().getCvsExecutablePath();
        if (cvsExe == null) {
            cvsExe = "cvs";
        }
        cmdLine.setExecutable(cvsExe);
        cmdLine.createArgument().setValue("-d" + cvsRoot);
        return cmdLine;
    }

    protected CvsRevision getHeadRevision() {
        CvsRevision revision = new CvsRevision();
        if (this.getTag() != null) {
            revision.setTag(this.getTag());
        } else {
            revision.setDate(new Date());
        }
        return revision;
    }

    public List<String> listModules() {
        ArrayList<String> list = new ArrayList<String>();
        for (String module : StringUtils.split((String)this.getModules(), (String)",\n")) {
            if ((module = module.trim()).length() == 0) continue;
            list.add(module);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void labelOnRevision(CvsRevision revision, String label, String comment) {
        File passwdFile = this.createPasswdFile(this.getCvsPassword());
        try {
            if (this.getBranch() != null && revision.getTag() == null) {
                Context.getLogger().info("Updating modules before tagging branch...");
                this.checkoutByRevision(revision);
                for (String module : this.listModules()) {
                    Context.getLogger().info("Tagging module: " + module);
                    File moduleDir = new File(this.getDestDir(), module);
                    Commandline cmdline = this.buildCvsCmd(this.getCvsRoot());
                    cmdline.addArgLine("tag -F").addArgValue(label);
                    cmdline.execute(moduleDir, this.createPasswdEnv(passwdFile), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
                }
            } else {
                for (String module : this.listModules()) {
                    Context.getLogger().info("Tagging module: " + module);
                    Commandline cmdline = this.buildCvsCmd(this.getCvsRoot());
                    if (!Context.getLogger().isInfoEnabled()) {
                        cmdline.addArgValue("-Q");
                    }
                    cmdline.addArgValue("rtag");
                    if (revision.getTag() != null) {
                        cmdline.addArgValue("-r").addArgValue(revision.getTag());
                    } else {
                        cmdline.addArgValue("-D").addArgValue(this.getInputDateTimeFormatter().print((ReadableInstant)new DateTime((Object)revision.getDate())));
                    }
                    cmdline.addArgValue("-F").addArgValue(label).addArgValue(module);
                    cmdline.execute(this.createPasswdEnv(passwdFile), (OutputStream)new LineConsumer.DebugLogger(), new LineConsumer(){

                        public void consume(String line) {
                            if (line.startsWith("cvs rtag")) {
                                Context.getLogger().debug(line);
                            } else {
                                Context.getLogger().warn(line);
                            }
                        }
                    }).checkReturnCode();
                }
            }
        }
        finally {
            FileUtils.deleteFile((File)passwdFile);
        }
    }

    File createPasswdFile(String password) {
        File passwdFile = FileUtils.createTempFile((String)"passwd");
        try {
            if (password == null) {
                password = "";
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < password.length(); ++i) {
                buf.append(PASSWORD_SHIFTS[password.charAt(i)]);
            }
            String mangledPassword = "A" + buf.toString();
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(this.getCvsRoot() + " " + mangledPassword);
            FileUtils.writeFile((File)passwdFile, lines);
            if (SystemUtils.IS_OS_WINDOWS) {
                Commandline cmdline = new Commandline();
                cmdline.setExecutable(FileUtils.locateLib(CvsRepository.class, (String)"cvsnt-passwd.exe").getAbsolutePath());
                cmdline.addArgValue(this.getCvsRoot());
                cmdline.execute((OutputStream)new LineConsumer.NoOp(), (LineConsumer)new LineConsumer.WarnLogger(), mangledPassword).checkReturnCode();
            }
            return passwdFile;
        }
        catch (Exception e) {
            FileUtils.deleteFile((File)passwdFile);
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    Environment createPasswdEnv(File passwdFile) {
        Environment envs = new Environment();
        Environment.Variable var = new Environment.Variable();
        var.setKey("CVS_PASSFILE");
        var.setValue(passwdFile.getAbsolutePath());
        envs.addVariable(var);
        return envs;
    }

    public SourceViewSupport<CvsRevision> getSourceViewSupport() {
        return new CvsSourceViewSupport(this);
    }

    public void validate(Set<String> properties, ErrorContext errorContext) {
        if (properties.contains("branch") && properties.contains("tag") && this.getBranch() != null && this.getTag() != null) {
            errorContext.setError("branch", "Tag and branch can not be specified in the same time");
            errorContext.setError("tag", "Tag and branch can not be specified in the same time");
        }
    }

    protected boolean isQuietSince(Date date) {
        if (this.getTag() == null) {
            CvsRevision sinceRevision = new CvsRevision();
            sinceRevision.setDate(date);
            CvsRevision currentRevision = new CvsRevision();
            currentRevision.setDate(new Date());
            return this.getChangesBetween(sinceRevision, currentRevision).isEmpty();
        }
        return true;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().element("repositoryPaths").detach();
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        Element proofBuildSupportElement = dom.getRootElement().element("proofBuildSupport");
        if (proofBuildSupportElement != null) {
            proofBuildSupportElement.addElement("proofCondition").addAttribute("class", "com.pmease.quickbuild.setting.repository.proofcondition.AlwaysProof");
        }
    }
}

