/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.cvs;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.cvs.CvsRepository;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi
public class CvsProofBuildSupport
extends ProofBuildSupport<LocalChange> {
    private CvsRepository repository;
    private String cvsRoot;
    private String cvsPassword;
    private String workingCopies;
    private String updateCondition = "true";
    private String commitCondition = "build.successful";
    private String commitComment;

    @Editable(name="CVS Root", order=10, description="Specify CVS root to be used at the user's desktop. If left empty, CVS root specified at repository level will be used.")
    @ScriptApi(value="Get CVS root used at user's desktop. Null if not specified.")
    @Scriptable
    public String getCvsRoot() {
        return this.cvsRoot;
    }

    public void setCvsRoot(String cvsRoot) {
        this.cvsRoot = cvsRoot;
    }

    @Editable(name="CVS Password", order=20, description="Specify CVS password to be used at the user's desktop if connecting using pserver protocol. If left empty, CVS password defined at repository level will be used.")
    @Password
    @ScriptApi(value="Get password used at user's desktop. Null if not specified.")
    @Scriptable
    public String getCvsPassword() {
        return this.cvsPassword;
    }

    public void setCvsPassword(String cvsPassword) {
        this.cvsPassword = cvsPassword;
    }

    @Editable(order=100, description="Specify working copy paths at user's desktop. Local change will be collected from these working copies and sent to QuickBuild to run a proof build.<br><strong>NOTE:</strong> mutiple working copy paths need to be separated by comma or new line character.")
    @NotEmpty
    @ScriptApi(value="Get working copies at user's desktop to collect local change from.")
    @Scriptable
    public String getWorkingCopies() {
        return this.workingCopies;
    }

    public void setWorkingCopies(String workingCopies) {
        this.workingCopies = workingCopies;
    }

    @Editable(order=200, description="Specify the condition to update working copies. If this condition is satisfied, the work copies specified above will be updated before local change is collected. Updating working copies will make the proof build more accurate and you should normally set this condition to <b>true</b>.")
    @Expressions(value={"always update", "true", "do not update", "false"})
    @NotEmpty
    @ScriptApi(value="Get the condition to update working copies.")
    @Scriptable
    public String getUpdateCondition() {
        return this.updateCondition;
    }

    public void setUpdateCondition(String updateCondition) {
        this.updateCondition = updateCondition;
    }

    @Editable(order=300, description="Specify the condition to commit local change. If this condition is satisfied, local change in the workspace specified above will be commit after the build finishes.")
    @Expressions(value={"commit only when build is successful", "build.successful", "always commit", "true", "do not commit", "false"})
    @NotEmpty
    @ScriptApi(value="Get the condition to commit local change after build finishes.")
    @Scriptable
    public String getCommitCondition() {
        return this.commitCondition;
    }

    public void setCommitCondition(String commitCondition) {
        this.commitCondition = commitCondition;
    }

    @Editable(order=400, description="Specify the comment when commit the local change. This property only takes effect if the commit condition specified above is satisfied.")
    @Multiline
    @ScriptApi(value="Get commit comment of local change. Null if not specified.")
    @Scriptable
    public String getCommitComment() {
        return this.commitComment;
    }

    public void setCommitComment(String commitComment) {
        this.commitComment = commitComment;
    }

    public CvsProofBuildSupport(CvsRepository repository) {
        this.repository = repository;
    }

    private List<File> getWorkingCopyDirs() {
        ArrayList<File> workingCopies = new ArrayList<File>();
        for (String workingCopyPath : StringUtils.split((String)this.getWorkingCopies(), (String)"\n\r,")) {
            workingCopies.add(new File(workingCopyPath));
        }
        return workingCopies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished() {
        Boolean isCommit = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getCommitCondition(), Context.buildEvalContext((Object)((Object)this.repository), null));
        if (isCommit.booleanValue()) {
            Context.getLogger().info("Committing local change...");
            File passwdFile = this.repository.createPasswdFile(this.getCvsPassword() != null ? this.getCvsPassword() : this.repository.getCvsPassword());
            try {
                for (File workingCopy : this.getWorkingCopyDirs()) {
                    Commandline cmdline = this.repository.buildCvsCmd(this.getCvsRoot() != null ? this.getCvsRoot() : this.repository.getCvsRoot());
                    if (!Context.getLogger().isInfoEnabled()) {
                        cmdline.addArgValue("-Q");
                    }
                    cmdline.createArgument().setLine("commit -m");
                    if (this.getCommitComment() != null) {
                        cmdline.addArgValue(this.getCommitComment());
                    } else {
                        cmdline.addArgValue("Committed by QuickBuild as result of proof build.");
                    }
                    cmdline.execute(workingCopy, this.repository.createPasswdEnv(passwdFile), (OutputStream)new LineConsumer.InfoLogger(), new LineConsumer(){

                        public void consume(String line) {
                            if (!line.startsWith("cvs commit: Examining")) {
                                Context.getLogger().warn(line);
                            } else {
                                Context.getLogger().debug(line);
                            }
                        }
                    }).checkReturnCode();
                }
            }
            finally {
                FileUtils.deleteFile((File)passwdFile);
            }
        }
    }

    public File getCheckoutFile(String repositoryPath) {
        for (String module : this.repository.listModules()) {
            if (FileUtils.getRelativePath((String)repositoryPath, (String)module) == null) continue;
            return new File(this.repository.getDestDir(), repositoryPath);
        }
        return null;
    }

    private String readRepositoryPath(File file) {
        String repositoryPath = FileUtils.readFileAsString((File)new File(file.getParentFile(), "CVS/Repository")).trim();
        if (repositoryPath.equals(".")) {
            return file.getName();
        }
        return repositoryPath + "/" + file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChange getLocalChange(File changeStoreDir) {
        File passwdFile = this.repository.createPasswdFile(this.getCvsPassword() != null ? this.getCvsPassword() : this.repository.getCvsPassword());
        try {
            Boolean isUpdate = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getUpdateCondition(), Context.buildEvalContext((Object)((Object)this.repository), null));
            if (isUpdate.booleanValue()) {
                Context.getLogger().info("Updating working copies...");
                for (File workingCopy : this.getWorkingCopyDirs()) {
                    Commandline cmdline = this.repository.buildCvsCmd(this.getCvsRoot() != null ? this.getCvsRoot() : this.repository.getCvsRoot());
                    if (!Context.getLogger().isInfoEnabled()) {
                        cmdline.addArgValue("-Q");
                    }
                    cmdline.addArgLine("update -P -d");
                    cmdline.execute(workingCopy, this.repository.createPasswdEnv(passwdFile), (OutputStream)new LineConsumer.InfoLogger(), new LineConsumer(){

                        public void consume(String line) {
                            if (!line.startsWith("cvs server: Updating")) {
                                Context.getLogger().warn(line);
                            } else {
                                Context.getLogger().debug(line);
                            }
                        }
                    }).checkReturnCode();
                }
            }
            Context.getLogger().info("Checking status of working copies...");
            LocalChange change = new LocalChange();
            for (final File workingCopy : this.getWorkingCopyDirs()) {
                String repositoryPath;
                final Boolean[] conflictsFound = new Boolean[]{false};
                Commandline cmdline = this.repository.buildCvsCmd(this.getCvsRoot() != null ? this.getCvsRoot() : this.repository.getCvsRoot());
                cmdline.createArgument().setValue("status");
                final ArrayList potentialConflicts = new ArrayList();
                final ArrayList modifiedFiles = new ArrayList();
                final ArrayList addedFiles = new ArrayList();
                final ArrayList deletedFiles = new ArrayList();
                cmdline.execute(workingCopy, this.repository.createPasswdEnv(passwdFile), (OutputStream)new LineConsumer(){
                    private File examineDir = null;

                    public void consume(String line) {
                        if (line.startsWith("cvs server: Examining ")) {
                            Context.getLogger().debug(line);
                            String subdir = line.substring("cvs server: Examining ".length());
                            this.examineDir = !subdir.equals(".") ? new File(workingCopy, subdir) : workingCopy;
                        } else if (line.startsWith("cvs status: Examining ")) {
                            Context.getLogger().debug(line);
                            String subdir = line.substring("cvs status: Examining ".length());
                            this.examineDir = !subdir.equals(".") ? new File(workingCopy, subdir) : workingCopy;
                        } else if (line.contains("Status: Unresolved Conflict")) {
                            Context.getLogger().error(line);
                            conflictsFound[0] = true;
                        } else if (line.contains("Status: File had conflicts on merge")) {
                            Context.getLogger().error(line);
                            String fileName = StringUtils.substringBefore((String)StringUtils.substringAfter((String)line, (String)"File:"), (String)"Status:").trim();
                            potentialConflicts.add(new File(this.examineDir, fileName));
                        } else if (line.contains("Status: Locally Modified")) {
                            Context.getLogger().debug(line);
                            String fileName = StringUtils.substringBefore((String)StringUtils.substringAfter((String)line, (String)"File:"), (String)"Status:").trim();
                            modifiedFiles.add(new File(this.examineDir, fileName));
                        } else if (line.contains("Status: Locally Added")) {
                            Context.getLogger().debug(line);
                            String fileName = StringUtils.substringBefore((String)StringUtils.substringAfter((String)line, (String)"File:"), (String)"Status:").trim();
                            addedFiles.add(new File(this.examineDir, fileName));
                        } else if (line.contains("Status: Locally Removed")) {
                            Context.getLogger().debug(line);
                            String fileName = StringUtils.substringBefore((String)StringUtils.substringAfter((String)line, (String)"File: no file"), (String)"Status:").trim();
                            deletedFiles.add(new File(this.examineDir, fileName));
                        } else {
                            Context.getLogger().debug(line);
                        }
                    }
                }, null).checkReturnCode();
                if (conflictsFound[0].booleanValue()) {
                    throw new QuickbuildException("Failed to collect local change: conflicts found in user's working copies");
                }
                block5: for (File file : potentialConflicts) {
                    File entryFile = new File(file.getParentFile(), "CVS/Entries");
                    for (String fileLine : FileUtils.readFileAsLines((File)entryFile)) {
                        if (!fileLine.startsWith("/" + file.getName())) continue;
                        Date conflictDate = CvsRepository.ENTRY_DATETIME_FORMATTER.parseDateTime(StringUtils.substringBefore((String)StringUtils.substringAfter((String)fileLine.substring(("/" + file.getName()).length()), (String)"Result of merge+"), (String)"/") + " +0000").toDate();
                        if (file.lastModified() - conflictDate.getTime() < 2000L) {
                            throw new QuickbuildException("Failed to collect local change: conflicts found in user's working copies");
                        }
                        String repositoryPath2 = this.readRepositoryPath(file);
                        FileUtils.copyFile((File)file, (File)new File(changeStoreDir, repositoryPath2));
                        change.getModifyPaths().add(repositoryPath2);
                        continue block5;
                    }
                }
                for (File file : modifiedFiles) {
                    repositoryPath = this.readRepositoryPath(file);
                    FileUtils.copyFile((File)file, (File)new File(changeStoreDir, repositoryPath));
                    change.getModifyPaths().add(repositoryPath);
                }
                for (File file : addedFiles) {
                    repositoryPath = this.readRepositoryPath(file);
                    FileUtils.copyFile((File)file, (File)new File(changeStoreDir, repositoryPath));
                    change.getAddPaths().add(repositoryPath);
                }
                for (File file : deletedFiles) {
                    repositoryPath = this.readRepositoryPath(file);
                    change.getDeletePaths().add(repositoryPath);
                }
            }
            LocalChange localChange = change;
            return localChange;
        }
        finally {
            FileUtils.deleteFile((File)passwdFile);
        }
    }

    @ScriptApi(value="Get the repository object.")
    public CvsRepository getRepository() {
        return this.repository;
    }
}

