/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.helper.ini;

import com.pmease.quickbuild.plugin.scm.helper.ini.IniPart;
import com.pmease.quickbuild.plugin.scm.helper.ini.IniProperty;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IniSection
implements IniPart {
    private String name;
    private List<IniProperty> properties;
    private Map<String, IniProperty> propertyMap = new HashMap<String, IniProperty>();

    public IniSection() {
        this.properties = new ArrayList<IniProperty>();
    }

    public IniSection(String name) {
        this();
        this.name = name;
    }

    public List<IniProperty> getProperties() {
        return this.properties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IniProperty getProperty(String name) {
        return this.propertyMap.get(name);
    }

    public void setProperty(IniProperty property) {
        IniProperty prop = this.propertyMap.get(property.getName());
        if (prop != null) {
            int idx = this.properties.indexOf(prop);
            this.properties.set(idx, property);
        } else {
            this.properties.add(property);
        }
        this.propertyMap.put(property.getName(), property);
    }

    public void setProperty(String name, String value) {
        this.setProperty(new IniProperty(name, value));
    }

    public void removeProperty(String name) {
        IniProperty prop = this.propertyMap.get(name);
        if (prop != null) {
            int idx = this.properties.indexOf(prop);
            this.properties.remove(idx);
            this.propertyMap.remove(name);
        }
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write("[" + this.name + "]");
        writer.write(System.getProperty("line.separator"));
        Iterator<IniProperty> it = this.properties.iterator();
        IniProperty prop = null;
        while (it.hasNext()) {
            prop = it.next();
            prop.write(writer);
            writer.write(System.getProperty("line.separator"));
        }
    }
}

