/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.helper.ini;

import com.pmease.quickbuild.plugin.scm.helper.ini.IniProperty;
import com.pmease.quickbuild.plugin.scm.helper.ini.IniSection;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class IniFile {
    private List<IniSection> sections = new ArrayList<IniSection>();
    private Map<String, IniSection> sectionMap = new HashMap<String, IniSection>();

    public List<IniSection> getSections() {
        return this.sections;
    }

    public IniSection getSection(String name) {
        return this.sectionMap.get(name);
    }

    public void addSection(IniSection section) {
        IniSection sec = this.sectionMap.get(section.getName());
        if (sec != null) {
            int idx = this.sections.indexOf(sec);
            this.sections.set(idx, section);
        } else {
            this.sections.add(section);
        }
        this.sectionMap.put(section.getName(), section);
    }

    public void removeSection(String name) {
        IniSection sec = this.sectionMap.get(name);
        if (sec != null) {
            int idx = this.sections.indexOf(sec);
            this.sections.remove(idx);
            this.sectionMap.remove(name);
        }
    }

    public String getProperty(String section, String property) {
        IniProperty prop;
        String value = null;
        IniSection sec = this.getSection(section);
        if (sec != null && (prop = sec.getProperty(property)) != null) {
            value = prop.getValue();
        }
        return value;
    }

    public void setProperty(String section, String property, String value) {
        IniSection sec = this.getSection(section);
        if (sec == null) {
            sec = new IniSection(section);
            this.addSection(sec);
        }
        sec.setProperty(new IniProperty(property, value));
    }

    public void removeProperty(String section, String property) {
        IniSection sec = this.getSection(section);
        if (sec != null) {
            sec.removeProperty(property);
        }
    }

    public void write(Writer writer) {
        Iterator<IniSection> it = this.sections.iterator();
        IniSection section = null;
        try {
            while (it.hasNext()) {
                section = it.next();
                section.write(writer);
                writer.write(System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public void save(File file) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            this.write(writer);
        }
        catch (IOException e) {
            try {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void load(File file) {
        if (!file.exists()) {
            return;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            this.read(reader);
        }
        catch (FileNotFoundException e) {
            try {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    public void read(Reader reader) {
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        IniSection currentSection = new IniSection("NONE");
        try {
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.startsWith(";")) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    String secName = line.substring(1, line.length() - 1);
                    currentSection = this.getSection(secName);
                    if (currentSection != null) continue;
                    currentSection = new IniSection(secName);
                    this.addSection(currentSection);
                    continue;
                }
                String name = line;
                String value = "";
                int pos = line.indexOf("=");
                if (pos != -1) {
                    name = StringUtils.stripEnd((String)line.substring(0, pos), (String)" ");
                    value = StringUtils.stripStart((String)line.substring(pos + 1), (String)" ");
                }
                currentSection.setProperty(new IniProperty(name, value));
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }
}

