/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.helper.consumer;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.log.Log;
import org.slf4j.Logger;

public class LoggerConsumer
extends LineConsumer {
    protected Logger logger;
    private Log.LogLevel level = Log.LogLevel.INFO;

    public LoggerConsumer(String encoding) {
        this(Log.LogLevel.INFO, encoding);
    }

    public LoggerConsumer(Log.LogLevel level, String encoding) {
        this(Context.getLogger(), level, encoding);
    }

    public LoggerConsumer(Logger logger, Log.LogLevel level, String encoding) {
        super(encoding);
        this.logger = logger;
        this.level = level;
    }

    public static LoggerConsumer traceConsumer() {
        return new LoggerConsumer(Log.LogLevel.TRACE, "UTF-8");
    }

    public static LoggerConsumer debugConsumer() {
        return new LoggerConsumer(Log.LogLevel.DEBUG, "UTF-8");
    }

    public static LoggerConsumer infoConsumer() {
        return new LoggerConsumer(Log.LogLevel.INFO, "UTF-8");
    }

    public static LoggerConsumer warnConsumer() {
        return new LoggerConsumer(Log.LogLevel.WARN, "UTF-8");
    }

    public static LoggerConsumer errorConsumer() {
        return new LoggerConsumer(Log.LogLevel.ERROR, "UTF-8");
    }

    public static LoggerConsumer nullConsumer() {
        return new LoggerConsumer(null, "UTF-8");
    }

    public static LoggerConsumer logConsumer() {
        if (Context.getLogger().isErrorEnabled()) {
            return LoggerConsumer.errorConsumer();
        }
        if (Context.getLogger().isWarnEnabled()) {
            return LoggerConsumer.warnConsumer();
        }
        if (Context.getLogger().isInfoEnabled()) {
            return LoggerConsumer.infoConsumer();
        }
        if (Context.getLogger().isDebugEnabled()) {
            return LoggerConsumer.debugConsumer();
        }
        return LoggerConsumer.traceConsumer();
    }

    public void consume(String line) {
        this.logLine(line);
    }

    protected void logLine(String line) {
        if (this.level == null) {
            return;
        }
        switch (this.level) {
            case ERROR: {
                this.logger.error(line);
                break;
            }
            case WARN: {
                this.logger.warn(line);
                break;
            }
            case INFO: {
                this.logger.info(line);
                break;
            }
            case TRACE: {
                this.logger.trace(line);
                break;
            }
            case DEBUG: {
                this.logger.debug(line);
                break;
            }
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Log.LogLevel getLogLevel() {
        return this.level;
    }

    public void setLogLevel(Log.LogLevel level) {
        this.level = level;
    }
}

