/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.helper.consumer;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.helper.consumer.LoggerConsumer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class LineListConsumer
extends LoggerConsumer {
    protected final List<String> lines = new ArrayList<String>();
    protected final int maxLines;

    public LineListConsumer(String encoding) {
        this(Log.LogLevel.INFO, encoding);
    }

    public LineListConsumer(Log.LogLevel level, String encoding) {
        this(Integer.MAX_VALUE, level, encoding);
    }

    public LineListConsumer(int maxLines, Log.LogLevel level, String encoding) {
        this(maxLines, Context.getLogger(), level, encoding);
    }

    public LineListConsumer(int maxLines, Logger logger, Log.LogLevel level, String encoding) {
        super(logger, level, encoding);
        this.maxLines = maxLines;
    }

    @Override
    public void consume(String line) {
        super.consume(line);
        if (this.maxLines == 0 || this.maxLines > 0 && this.lines.size() < this.maxLines) {
            this.lines.add(line);
        }
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String firstLine() {
        if (this.lines.isEmpty()) {
            return "";
        }
        return this.lines.get(0);
    }

    public String lastLine() {
        if (this.lines.isEmpty()) {
            return "";
        }
        return this.lines.get(this.lines.size() - 1);
    }

    public String getContent() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.lines.size(); ++i) {
            sb.append(this.lines.get(i));
            if (i + 1 >= this.lines.size()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getMaxLines() {
        return this.maxLines;
    }
}

