/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.helper;

import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;

public abstract class ScmUrl {
    public static final String PROTOCOL_SEPARATOR = "://";
    private String originalUrl;
    private String protocol;
    private String urlPart;
    private String username;
    private String password;

    protected abstract String[] supportedProtocols();

    protected abstract String[] protocolsSupportUsername();

    public ScmUrl(String originalUrl, String username, String password) {
        this.originalUrl = originalUrl;
        this.parseUrl(originalUrl);
        this.username = username;
        this.password = password;
    }

    private void parseUrl(String originalUrl) {
        int pos = originalUrl.indexOf(PROTOCOL_SEPARATOR);
        if (pos > 0) {
            this.protocol = originalUrl.substring(0, pos).toLowerCase();
            this.urlPart = originalUrl.substring(pos + PROTOCOL_SEPARATOR.length());
        } else {
            this.urlPart = originalUrl;
        }
        this.validateProtocol();
    }

    protected void validateProtocol() {
        if (StringUtils.isEmpty((String)this.protocol)) {
            return;
        }
        for (String each : this.supportedProtocols()) {
            if (!each.equals(this.protocol)) continue;
            return;
        }
        throw new ScmException("Unsupported protocol for url \"" + this.originalUrl + "\"");
    }

    protected String[] protocolsSupportPassword() {
        return this.protocolsSupportUsername();
    }

    private boolean urlSupportUsername() {
        for (String each : this.protocolsSupportUsername()) {
            if (!each.equals(this.protocol)) continue;
            return true;
        }
        return false;
    }

    private boolean urlSupportPassword() {
        for (String each : this.protocolsSupportPassword()) {
            if (!each.equals(this.protocol)) continue;
            return true;
        }
        return false;
    }

    private String buildUrl(boolean shadowPassword) {
        if (this.protocol == null) {
            return this.originalUrl;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.protocol + PROTOCOL_SEPARATOR);
        if (!StringUtils.isEmpty((String)this.username) && this.urlSupportUsername()) {
            try {
                sb.append(URLEncoder.encode(this.username, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (!StringUtils.isEmpty((String)this.password)) {
                sb.append(":");
                if (shadowPassword) {
                    sb.append("******");
                } else {
                    try {
                        sb.append(URLEncoder.encode(this.password, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            sb.append("@");
        }
        sb.append(this.urlPart);
        return sb.toString();
    }

    public String toDescriptiveString() {
        return this.buildUrl(true);
    }

    public String toString() {
        return this.buildUrl(false);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUrlPart() {
        return this.urlPart;
    }

    public void setUrlPart(String urlPart) {
        this.urlPart = urlPart;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }
}

