/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.helper;

import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.SecretMasker;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public abstract class ScmCommand<T extends AbstractRepository>
extends Commandline {
    protected final T repository;
    protected final File workingDir;
    protected String outputEncoding;

    protected abstract String getExePath();

    public ScmCommand(T repository) {
        this.repository = repository;
        this.workingDir = ((AbstractRepository)((Object)repository)).getWorkingDir();
        this.setExecutable(this.getExePath());
    }

    public ScmCommand<T> setLine(String line) {
        this.addArgLine(line);
        return this;
    }

    public ScmCommand<T> setValue(String value) {
        return this.setValue(value, null);
    }

    public ScmCommand<T> setValue(final String value, final String descriptiveValue) {
        Commandline.Argument argument = this.createArgument();
        argument.setValue(value);
        if (!StringUtils.isEmpty((String)descriptiveValue)) {
            this.setSecretMasker(new SecretMasker(){

                public String mask(String message) {
                    return StringUtils.replace((String)message, (String)value, (String)descriptiveValue);
                }
            });
        }
        return this;
    }

    public ScmCommand<T> addParameter(String arg, String value) {
        return this.addParameter(arg, value, null);
    }

    public ScmCommand<T> addParameter(String arg, String value, String descriptiveValue) {
        this.setLine(arg);
        this.setValue(value, descriptiveValue);
        return this;
    }

    public T getRepository() {
        return this.repository;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }
}

