/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.helper;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.helper.ScmCommand;
import com.pmease.quickbuild.plugin.scm.helper.ScmHelperPlugin;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScmCli<T extends ScmCli, R extends AbstractRepository, F extends ScmCommand> {
    private static final Logger logger = LoggerFactory.getLogger(ScmCli.class);
    protected final R repository;
    protected static final Date INVALID_DATE = new DateTime(1975, 1, 1, 0, 0, 0, 0).toDate();
    protected final String encoding;

    protected abstract F createCommand();

    protected abstract void doSync();

    public ScmCli(R repository, String encoding) {
        this.repository = repository;
        this.encoding = encoding;
    }

    protected Logger getLogger() {
        if (ScmHelperPlugin.isTestMode()) {
            return logger;
        }
        return Context.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T sync() {
        File workingDir = ((AbstractRepository)((Object)this.getRepository())).getWorkingDir();
        this.getLogger().debug("sync working directory [" + workingDir + "]...");
        boolean b = ((AbstractRepository)((Object)this.getRepository())).hasSettingChanged();
        if (!workingDir.exists()) {
            this.getLogger().info("Repository does not exist, creating...");
        } else if (b) {
            this.getLogger().info("Repository setting changed, deleting working directory [" + workingDir + "]");
            FileUtils.deleteDir((File)workingDir);
        }
        try {
            this.doSync();
            ScmCli scmCli = this;
            return (T)scmCli;
        }
        finally {
            if (b) {
                ((AbstractRepository)((Object)this.getRepository())).saveRC();
            }
        }
    }

    protected T run(F command, LineConsumer consumer) {
        return this.run(((AbstractRepository)((Object)this.getRepository())).getWorkingDir(), command, consumer);
    }

    protected T run(F command, LineConsumer outConsumer, LineConsumer errorConsumer) {
        return this.run(((AbstractRepository)((Object)this.getRepository())).getWorkingDir(), command, outConsumer, errorConsumer);
    }

    protected T run(File dir, F command, LineConsumer outConsumer) {
        return this.run(dir, command, outConsumer, (LineConsumer)new LineConsumer.ErrorLogger(this.encoding));
    }

    protected T run(File dir, F command, LineConsumer outConsumer, LineConsumer errorConsumer) {
        Commandline.ExecuteResult result = dir == null ? command.execute((OutputStream)outConsumer, errorConsumer) : command.execute(dir, (OutputStream)outConsumer, errorConsumer);
        result.checkReturnCode();
        return (T)this;
    }

    protected T run(String line, LineConsumer consumer) {
        return this.run(this.buildCommand(line), consumer);
    }

    protected F buildCommand(String line) {
        return this.buildCommand(line, "");
    }

    protected F buildCommand(String line, String value) {
        return this.buildCommand(line, new String[]{value});
    }

    protected F buildCommand(String line, String[] values) {
        F command = this.createCommand();
        ((ScmCommand)((Object)command)).setLine(line);
        if (values != null && values.length > 0) {
            for (String each : values) {
                if (StringUtils.isEmpty((String)each)) continue;
                ((ScmCommand)((Object)command)).setValue(each);
            }
        }
        return command;
    }

    public R getRepository() {
        return this.repository;
    }

    public File getWorkingDir() {
        return ((AbstractRepository)((Object)this.getRepository())).getWorkingDir();
    }
}

