/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.helper;

import com.google.common.base.Objects;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.changes.extensionpoint.ChangeFormatterSupport;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.plugin.scm.helper.ScmHelperPlugin;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.Revision;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository<T extends Revision>
extends Repository<T>
implements ChangeFormatterSupport {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRepository.class);
    private static final long serialVersionUID = 1L;

    public abstract String getDestPath();

    public abstract Properties getCurrentRC();

    public File getWorkingDir() {
        if (ScmHelperPlugin.isTestMode()) {
            return new File(this.getDestPath());
        }
        Configuration configuration = Context.getConfiguration();
        if (configuration == null) {
            return null;
        }
        return FileUtils.resolvePath((File)configuration.getWorkspaceDir(), (String)this.getDestPath());
    }

    protected Logger getLogger() {
        if (ScmHelperPlugin.isTestMode()) {
            return logger;
        }
        return Context.getLogger();
    }

    @ScriptApi(value="Get revision of this repository")
    public T getRevision() {
        return (T)super.getRevision();
    }

    public File getRCFile() {
        return new File(this.getWorkingDir(), ".qbcache/qb-scm.xml");
    }

    public void saveRC() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Saving scm rc file ...");
        }
        Properties properties = this.getCurrentRC();
        File file = this.getRCFile();
        try {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                FileUtils.createDir((File)dir);
            }
            properties.storeToXML(new FileOutputStream(file), null);
        }
        catch (FileNotFoundException e) {
            throw new ScmException("Unable to save repository properties to file", e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Properties loadRC() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Loading scm rc file ...");
        }
        Properties properties = new Properties();
        File file = this.getRCFile();
        if (!file.exists()) {
            return properties;
        }
        try {
            properties.loadFromXML(new FileInputStream(this.getRCFile()));
            return properties;
        }
        catch (FileNotFoundException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public boolean hasSettingChanged() {
        return !this.getChangedSettings().isEmpty();
    }

    public Map<String, Property> getChangedSettings() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Detect whether repository settings have been changed ...");
        }
        Properties previous = this.loadRC();
        Properties current = this.getCurrentRC();
        HashMap<String, Property> changedSettings = new HashMap<String, Property>();
        for (Object each : current.keySet()) {
            String key = (String)each;
            if (Objects.equal((Object)previous.getProperty(key), (Object)current.getProperty(key))) continue;
            changedSettings.put(key, new Property(key, previous.getProperty(key), current.getProperty(key)));
        }
        return changedSettings;
    }

    public String format(String field, Map<String, Object> map) {
        FormatType t = FormatType.valueOf(field.toUpperCase());
        switch (t) {
            case CHANGEID: {
                return (String)map.get("changeId");
            }
            case EDITION: {
                return (String)map.get("edition");
            }
        }
        return null;
    }

    protected static enum FormatType {
        CHANGEID,
        EDITION;

    }

    public static class Property {
        private String key;
        private String oldValue;
        private String currentValue;

        public Property() {
        }

        public Property(String key, String oldValue, String currentValue) {
            this.key = key;
            this.oldValue = oldValue;
            this.currentValue = currentValue;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public void setOldValue(String oldValue) {
            this.oldValue = oldValue;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(String currentValue) {
            this.currentValue = currentValue;
        }
    }
}

