/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.maven;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import java.util.Stack;
import org.dom4j.Element;

@ScriptApi(value="Global settings for Maven.")
public class MavenSetting {
    private String mavenHome;
    private String mavenExePath;
    private String mavenOptions;
    private boolean resolveEffectivePOM = true;

    @Editable(order=50, name="Maven Home", description="Specify Maven Home here if Maven does not exist in your system path or you do not want to use the default Maven. For example: <b>c:\\apache-maven-3.2.1</b>. If specified, this value will be passed as M2_HOME environment variable when executing Maven builds.")
    @Scriptable
    public String getMavenHome() {
        return this.mavenHome;
    }

    public void setMavenHome(String mavenHome) {
        this.mavenHome = mavenHome;
    }

    @Editable(order=100, name="Maven Executable Path", description="Optionally specify path to Maven executable, for example: <b>c:\\apache-maven-3.2.1\\bin\\mvn.bat</b> You only need to specify Maven executable if it does not reside under $M2_HOME/bin. ")
    @ScriptApi(value="Get maven executable path.")
    @Scriptable
    public String getMavenExePath() {
        return this.mavenExePath;
    }

    public void setMavenExePath(String mavenExePath) {
        this.mavenExePath = mavenExePath;
    }

    @Editable(order=200, name="Maven Global Options", description="Optionally specify maven options for all maven build steps. Please note that you should NOT specify below options as they'll be determined by QuickBuild for step setting:<br><b>-X, --debug, -q, --quiet, -D, --define</b>")
    @Scriptable
    @ScriptApi(value="Get maven options")
    public String getMavenOptions() {
        return this.mavenOptions;
    }

    public void setMavenOptions(String mavenOptions) {
        this.mavenOptions = mavenOptions;
    }

    @Editable(order=300, description="Whether or not to resolve effective POM when running maven build step. QuickBuild uses dependency information in effective POM to build the configuration dependency graph in system so that dependent configurations can be triggered automatically upon completion of Maven snapshot build. Generally you should enable this option unless you've encounter some problems when build your Maven projects.")
    public boolean isResolveEffectivePOM() {
        return this.resolveEffectivePOM;
    }

    public void setResolveEffectivePOM(boolean resolveEffectivePOM) {
        this.resolveEffectivePOM = resolveEffectivePOM;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element element = dom.getRootElement().element("repositoryUrl");
        if (element != null) {
            element.detach();
        }
        if ((element = dom.getRootElement().element("snapshotRepositoryUrl")) != null) {
            element.detach();
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("resolveEffectivePOM").setText("true");
    }
}

