/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.maven;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.extensionpoint.ConfigurationDataPopulator;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.TriggerDependencyContribution;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.builder.maven.Gav;
import com.pmease.quickbuild.plugin.builder.maven.MavenBuildStep;
import com.pmease.quickbuild.plugin.builder.maven.MavenSetting;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.stepsupport.Step;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class MavenPlugin
extends AbstractPlugin {
    public static final String GAVS = "mavenGavs";
    public static final String DEPENDENCY_GAVS = "mavenDependencyGavs";

    public Object[] getExtensions() {
        return new Object[]{new StepProvider(){

            public Class<? extends Step> getStepClass() {
                return MavenBuildStep.class;
            }
        }, new TriggerDependencyContribution(){

            public Set<Long> getTriggerDependencies(Build build) {
                HashSet<Long> dependencies = new HashSet<Long>();
                Set dependencyGavs = (Set)build.getReports().get(MavenPlugin.DEPENDENCY_GAVS);
                if (dependencyGavs != null) {
                    Iterator it = dependencyGavs.iterator();
                    while (it.hasNext()) {
                        if (((Gav)it.next()).getVersion().endsWith("SNAPSHOT")) continue;
                        it.remove();
                    }
                    for (Configuration each : CacheManager.instance.getConfigurations().values()) {
                        Set gavs;
                        if (each.getId().equals(build.getConfiguration().getId()) || (gavs = (Set)each.getData().get(MavenPlugin.GAVS)) == null || CollectionUtils.intersection((Collection)gavs, (Collection)dependencyGavs).isEmpty()) continue;
                        dependencies.add(each.getId());
                    }
                }
                return dependencies;
            }
        }, new ConfigurationDataPopulator(){

            public void populate(Build build, Map<String, Serializable> data) {
                Set gavs = (Set)build.getReports().get(MavenPlugin.GAVS);
                if (gavs != null) {
                    data.put(MavenPlugin.GAVS, new LinkedHashSet(gavs));
                }
            }
        }};
    }

    public Class<?> getSettingClass() {
        return MavenSetting.class;
    }

    public PluginCategory getCategory() {
        return PluginCategory.BUILDER;
    }
}

