/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.maven;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.builder.maven.Gav;
import com.pmease.quickbuild.plugin.builder.maven.MavenSetting;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.tools.ant.types.Environment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Maven", category={"Build"}, description="Configure a Maven based build step here. By default, QuickBuild executes \"mvn\" (or mvn.bat on Windows) to run this build step, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the Maven plugin through the plugin management page.")
@ScriptApi(value="This step calls Apache Maven to build projects.")
public class MavenBuildStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String workingPath;
    private String goals;
    private List<Property> buildProperties = new ArrayList<Property>();
    private String extraMavenOptions;
    private List<Property> environments = new ArrayList<Property>();
    private boolean syncBuildVersion = true;
    private int returnCode;

    @Editable(order=1100, name="Working Directory", description="Specify working directory of the Maven command. A non-absolute path is considered to be relative to the workspace directory. If not specified, the workspace directory will be used as working directory.")
    @ScriptApi(value="Get working directory of the Maven command. Null if the workspace directory is used as working directory.")
    @Scriptable
    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    @Editable(order=1200, description="Specify the goals to build. Use space to separate different goals (goal name containing spaces should be quoted in order not to be interpreted as multiple goals).")
    @NotEmpty
    @ScriptApi(value="Get Maven goals. Null if not specified.")
    @Scriptable
    public String getGoals() {
        return this.goals;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    @Editable(order=1250, description="If checked, build version will be set to version found in the POM.<br><b>NOTE:</b> This option only takes effect if the <i>Resolve Effective POM</i> option is enabled in Maven plugin setting in plugin management page.")
    public boolean isSyncBuildVersion() {
        return this.syncBuildVersion;
    }

    public void setSyncBuildVersion(boolean syncBuildVersion) {
        this.syncBuildVersion = syncBuildVersion;
    }

    @Editable(order=1300, description="Define build properties here to pass into Maven. For example, you may pass version of current build as property <i>buildVersion</i> by specifying property name as <i>buildVersion</i> and property value as <i>${build.version}</code></i>.<br><b>NOTE:</b> Properties with blank value will be ignored.")
    @ScriptApi(value="Get list of build properties passed to Maven.")
    public List<Property> getBuildProperties() {
        return this.buildProperties;
    }

    public void setBuildProperties(List<Property> buildProperties) {
        this.buildProperties = buildProperties;
    }

    @Editable(order=1500, description="Optionally specify extra Maven options. If specified, it will be appended to the maven global options specified in maven plugin setting. Please note that you should NOT specify below options as they'll be determined by QuickBuild:<br><b>-X, --debug, -q, --quiet, -D, --define</b>")
    @ScriptApi(value="Get extra Maven build options. Null if not specified.")
    @Scriptable
    @Advanced
    public String getExtraMavenOptions() {
        return this.extraMavenOptions;
    }

    public void setExtraMavenOptions(String extraMavenOptions) {
        this.extraMavenOptions = extraMavenOptions;
    }

    @Editable(name="Environment Variables", order=1600, description="Specify environment variables for Maven execution. For example, you may store version of current build into environment variable <i>buildVersion</i> by specifying variable name as <i>buildVersion</i> and variable value as <i>${build.version}</code></i>.<br><b>NOTE:</b> <ul><li>You may define environment variable <i>JAVA_HOME</i> here in order to build with your choosed JDK.<li>Environment variables with blank value will be ignored.</li></ul>")
    @ScriptApi(value="Get defined environment variables when executing the build command.")
    public List<Property> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<Property> environments) {
        this.environments = environments;
    }

    @ScriptApi(value="Get return code of Maven command.")
    public int getReturnCode() {
        return this.returnCode;
    }

    private Commandline getBuildCmd(MavenSetting mavenSetting, boolean resolveEffectivePOM) {
        Commandline cmdline = new Commandline();
        cmdline.setExecutable(this.getMavenExecutable(mavenSetting));
        String globalOpts = mavenSetting.getMavenOptions();
        if (StringUtils.isNotBlank((String)globalOpts)) {
            cmdline.createArgument().setLine(globalOpts);
        }
        if (StringUtils.isNotBlank((String)this.getExtraMavenOptions())) {
            cmdline.createArgument().setLine(this.getExtraMavenOptions());
        }
        for (Property property : this.getBuildProperties()) {
            if (!StringUtils.isNotBlank((String)property.getValue())) continue;
            cmdline.createArgument().setValue("-D" + property.getName() + "=" + property.getValue());
        }
        if (!resolveEffectivePOM) {
            String cmdLineDescription = cmdline.describe();
            if (!cmdLineDescription.matches(".*\\s(-X|--debug)($|\\s.*)") && Context.getLogger().isDebugEnabled()) {
                cmdline.createArgument().setValue("-X");
            }
            if (StringUtils.isNotBlank((String)this.getGoals())) {
                cmdline.createArgument().setLine(this.getGoals());
            }
        } else {
            cmdline.createArgument().setLine("help:effective-pom");
        }
        return cmdline;
    }

    private File getWorkingDir() {
        return FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getWorkingPath());
    }

    private String getMavenExecutable(MavenSetting mvnSetting) {
        String mvnExe = mvnSetting.getMavenExePath();
        if (mvnExe == null) {
            String mvnHome = mvnSetting.getMavenHome();
            if (mvnHome == null) {
                mvnExe = SystemUtils.IS_OS_WINDOWS ? "mvn.bat" : "mvn";
            } else {
                mvnHome = StringUtils.stripEnd((String)mvnHome, (String)"/\\");
                mvnExe = SystemUtils.IS_OS_WINDOWS ? mvnHome + "\\bin\\mvn.bat" : mvnHome + "/bin/mvn";
            }
        }
        return mvnExe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Commandline cmdline;
        MavenSetting mavenSetting = (MavenSetting)this.getPlugin().getSetting(true);
        Environment env = new Environment();
        String mvnHome = mavenSetting.getMavenHome();
        if (mvnHome != null) {
            Environment.Variable var = new Environment.Variable();
            var.setKey("M2_HOME");
            var.setValue(mvnHome);
            env.addVariable(var);
        }
        for (Property each : this.getActualEnvironments(this.getEnvironments())) {
            if (!StringUtils.isNotBlank((String)each.getValue())) continue;
            Environment.Variable var = new Environment.Variable();
            var.setKey(each.getName());
            var.setValue(each.getValue());
            env.addVariable(var);
        }
        final StringBuffer errorMessages = new StringBuffer();
        try {
            cmdline = this.getBuildCmd(mavenSetting, false);
            final boolean[] successful = new boolean[]{false};
            final String[] invokeDirError = new String[]{null};
            Commandline.ExecuteResult result = cmdline.execute(this.getWorkingDir(), env, (OutputStream)new LineConsumer(){
                private boolean inErrorBlock = false;

                public void consume(String line) {
                    if (!this.isDownloadCounter(line)) {
                        if (line.startsWith("[ERROR] ")) {
                            String errorMessage = line.substring("[ERROR] ".length());
                            Context.getLogger().error(errorMessage);
                            errorMessages.append(errorMessage).append("\n");
                            this.inErrorBlock = true;
                        } else if (line.equals("[INFO] BUILD FAILURE")) {
                            Context.getLogger().error(line.substring("[INFO] ".length()));
                            this.inErrorBlock = false;
                        } else if (line.startsWith("[INFO] ")) {
                            Context.getLogger().info(line.substring("[INFO] ".length()));
                            this.inErrorBlock = false;
                        } else if (line.startsWith("[DEBUG] ")) {
                            Context.getLogger().debug(line.substring("[DEBUG] ".length()));
                            this.inErrorBlock = false;
                        } else if (line.startsWith("[WARNING] ")) {
                            Context.getLogger().warn(line.substring("[WARNING] ".length()));
                            this.inErrorBlock = false;
                        } else if (this.inErrorBlock) {
                            Context.getLogger().error(line);
                            errorMessages.append(line).append("\n");
                        } else {
                            Context.getLogger().info(line);
                        }
                    }
                    if (line.contains("BUILD SUCCESSFUL") || line.contains("BUILD SUCCESS")) {
                        successful[0] = true;
                    } else if (line.contains("Please verify you invoked Maven from the correct directory.")) {
                        invokeDirError[0] = line.startsWith("[ERROR] ") ? line.substring("[ERROR] ".length()) : line;
                    }
                }

                private boolean isDownloadCounter(String logLine) {
                    if (logLine.endsWith("/?")) {
                        String prefix = logLine.substring(0, logLine.length() - 2);
                        return NumberUtils.isDigits((String)prefix);
                    }
                    String temp = null;
                    if ((logLine = logLine.trim().toLowerCase()).endsWith("kb") || logLine.endsWith("mb") || logLine.endsWith("gb")) {
                        temp = logLine.substring(0, logLine.length() - 2);
                    } else if (logLine.endsWith("b") || logLine.endsWith("k") || logLine.endsWith("m") || logLine.endsWith("g")) {
                        temp = logLine.substring(0, logLine.length() - 1);
                    }
                    if (temp != null) {
                        temp = temp.replace('/', '0').replace(' ', '0').replace('\t', '0').replace('k', '0').replace('b', '0').replace('m', '0').replace('g', '0');
                        return NumberUtils.isDigits((String)temp);
                    }
                    return false;
                }
            }, new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().warn(line);
                    if (line.contains("BUILD SUCCESSFUL") || line.contains("BUILD SUCCESS")) {
                        successful[0] = true;
                    }
                }
            }, "\n");
            this.returnCode = result.getReturnCode();
            if (invokeDirError[0] != null) {
                throw new QuickbuildException(invokeDirError[0]);
            }
            if (result.getReturnCode() != 0) {
                if (errorMessages.length() != 0) {
                    throw new QuickbuildException(errorMessages.toString().trim());
                }
                result.buildException();
            }
            if (!successful[0]) {
                if (errorMessages.length() == 0) throw new QuickbuildException("Maven build failed.");
                throw new QuickbuildException(errorMessages.toString().trim());
            }
            if (!mavenSetting.isResolveEffectivePOM()) return;
            cmdline = this.getBuildCmd(mavenSetting, true);
        }
        catch (Throwable throwable) {
            if (!mavenSetting.isResolveEffectivePOM()) throw throwable;
            Commandline cmdline2 = this.getBuildCmd(mavenSetting, true);
            Context.getLogger().info("Checking project gavs and dependency gavs...");
            String[] invokeDirError3 = new String[]{null};
            File tempFile2 = FileUtils.createTempFile((String)"maven");
            try {
                Document pom;
                StringBuffer checkPOMErrorMessages = new StringBuffer();
                cmdline2.createArgument().setValue("-Doutput=" + tempFile2.getAbsolutePath());
                Commandline.ExecuteResult result3 = cmdline2.execute(this.getWorkingDir(), env, (OutputStream)new LineConsumer(checkPOMErrorMessages, invokeDirError3){
                    private boolean inErrorBlock = false;
                    final /* synthetic */ StringBuffer val$checkPOMErrorMessages;
                    final /* synthetic */ String[] val$invokeDirError;
                    {
                        this.val$checkPOMErrorMessages = stringBuffer;
                        this.val$invokeDirError = stringArray;
                    }

                    public void consume(String line) {
                        if (line.startsWith("[ERROR] ")) {
                            String errorMessage = line.substring("[ERROR] ".length());
                            Context.getLogger().error(errorMessage);
                            this.val$checkPOMErrorMessages.append(errorMessage).append("\n");
                            this.inErrorBlock = true;
                        } else if (line.equals("[INFO] BUILD FAILURE")) {
                            Context.getLogger().error(line.substring("[INFO] ".length()));
                            this.inErrorBlock = false;
                        } else if (line.startsWith("[INFO] ")) {
                            Context.getLogger().debug(line.substring("[INFO] ".length()));
                            this.inErrorBlock = false;
                        } else if (line.startsWith("[DEBUG] ")) {
                            Context.getLogger().debug(line.substring("[DEBUG] ".length()));
                            this.inErrorBlock = false;
                        } else if (line.startsWith("[WARNING] ")) {
                            Context.getLogger().warn(line.substring("[WARNING] ".length()));
                            this.inErrorBlock = false;
                        } else if (this.inErrorBlock) {
                            Context.getLogger().error(line);
                            this.val$checkPOMErrorMessages.append(line).append("\n");
                        } else {
                            Context.getLogger().debug(line);
                        }
                        if (line.contains("Please verify you invoked Maven from the correct directory.")) {
                            this.val$invokeDirError[0] = line.startsWith("[ERROR] ") ? line.substring("[ERROR] ".length()) : line;
                        }
                    }
                }, (LineConsumer)new LineConsumer.WarnLogger());
                if (invokeDirError3[0] != null) {
                    throw new QuickbuildException(invokeDirError3[0]);
                }
                if (result3.getReturnCode() != 0) {
                    if (checkPOMErrorMessages.length() != 0) {
                        throw new QuickbuildException(checkPOMErrorMessages.toString().trim());
                    }
                    result3.buildException();
                }
                if (Context.getLogger().isDebugEnabled()) {
                    Context.getLogger().debug("Effective POM: \n" + FileUtils.readFileAsString((File)tempFile2));
                }
                HashSet<Gav> gavs = new HashSet<Gav>();
                HashSet<Gav> dependencyGavs = new HashSet<Gav>();
                ArrayList<Element> projects = new ArrayList<Element>();
                try {
                    pom = new SAXReader().read(tempFile2);
                }
                catch (DocumentException e) {
                    SAXReader reader = new SAXReader();
                    reader.setEncoding(FileUtils.getDefaultEncoding());
                    pom = reader.read(tempFile2);
                }
                if (pom.getRootElement().getName().equals("project")) {
                    projects.add(pom.getRootElement());
                } else {
                    if (!pom.getRootElement().getName().equals("projects")) throw new QuickbuildException("Unrecognized pom format");
                    projects.addAll(pom.getRootElement().elements());
                }
                if (this.isSyncBuildVersion()) {
                    this.getBuild().setVersion(((Element)projects.get(0)).elementText("version").trim());
                }
                for (Element project : projects) {
                    if ("pom".equalsIgnoreCase(project.elementTextTrim("packaging"))) continue;
                    Gav gav = new Gav(project.elementText("groupId").trim(), project.elementText("artifactId").trim(), project.elementText("version").trim());
                    gavs.add(gav);
                    Element dependenciesElement = project.element("dependencies");
                    if (dependenciesElement == null) continue;
                    for (Element dependencyElement : dependenciesElement.elements()) {
                        gav = new Gav(dependencyElement.elementText("groupId").trim(), dependencyElement.elementText("artifactId").trim(), dependencyElement.elementText("version").trim());
                        dependencyGavs.add(gav);
                    }
                }
                Set existingGavs = (Set)this.getBuild().getReports().get("mavenGavs");
                if (existingGavs != null) {
                    gavs.addAll(existingGavs);
                }
                this.getBuild().getReports().put("mavenGavs", gavs);
                Set existingDependencyGavs = (Set)this.getBuild().getReports().get("mavenDependencyGavs");
                if (existingDependencyGavs != null) {
                    dependencyGavs.addAll(existingDependencyGavs);
                }
                this.getBuild().getReports().put("mavenDependencyGavs", dependencyGavs);
                throw throwable;
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
            finally {
                FileUtils.deleteFile((File)tempFile2);
            }
        }
        Context.getLogger().info("Checking project gavs and dependency gavs...");
        String[] invokeDirError2 = new String[]{null};
        File tempFile = FileUtils.createTempFile((String)"maven");
        try {
            Document pom;
            StringBuffer checkPOMErrorMessages = new StringBuffer();
            cmdline.createArgument().setValue("-Doutput=" + tempFile.getAbsolutePath());
            Commandline.ExecuteResult result2 = cmdline.execute(this.getWorkingDir(), env, (OutputStream)new /* invalid duplicate definition of identical inner class */, (LineConsumer)new LineConsumer.WarnLogger());
            if (invokeDirError2[0] != null) {
                throw new QuickbuildException(invokeDirError2[0]);
            }
            if (result2.getReturnCode() != 0) {
                if (checkPOMErrorMessages.length() != 0) {
                    throw new QuickbuildException(checkPOMErrorMessages.toString().trim());
                }
                result2.buildException();
            }
            if (Context.getLogger().isDebugEnabled()) {
                Context.getLogger().debug("Effective POM: \n" + FileUtils.readFileAsString((File)tempFile));
            }
            HashSet<Gav> gavs = new HashSet<Gav>();
            HashSet<Gav> dependencyGavs = new HashSet<Gav>();
            ArrayList<Element> projects = new ArrayList<Element>();
            try {
                pom = new SAXReader().read(tempFile);
            }
            catch (DocumentException e) {
                SAXReader reader = new SAXReader();
                reader.setEncoding(FileUtils.getDefaultEncoding());
                pom = reader.read(tempFile);
            }
            if (pom.getRootElement().getName().equals("project")) {
                projects.add(pom.getRootElement());
            } else {
                if (!pom.getRootElement().getName().equals("projects")) throw new QuickbuildException("Unrecognized pom format");
                projects.addAll(pom.getRootElement().elements());
            }
            if (this.isSyncBuildVersion()) {
                this.getBuild().setVersion(((Element)projects.get(0)).elementText("version").trim());
            }
            for (Element project : projects) {
                if ("pom".equalsIgnoreCase(project.elementTextTrim("packaging"))) continue;
                Gav gav = new Gav(project.elementText("groupId").trim(), project.elementText("artifactId").trim(), project.elementText("version").trim());
                gavs.add(gav);
                Element dependenciesElement = project.element("dependencies");
                if (dependenciesElement == null) continue;
                for (Element dependencyElement : dependenciesElement.elements()) {
                    gav = new Gav(dependencyElement.elementText("groupId").trim(), dependencyElement.elementText("artifactId").trim(), dependencyElement.elementText("version").trim());
                    dependencyGavs.add(gav);
                }
            }
            Set existingGavs = (Set)this.getBuild().getReports().get("mavenGavs");
            if (existingGavs != null) {
                gavs.addAll(existingGavs);
            }
            this.getBuild().getReports().put("mavenGavs", gavs);
            Set existingDependencyGavs = (Set)this.getBuild().getReports().get("mavenDependencyGavs");
            if (existingDependencyGavs != null) {
                dependencyGavs.addAll(existingDependencyGavs);
            }
            this.getBuild().getReports().put("mavenDependencyGavs", dependencyGavs);
            return;
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.deleteFile((File)tempFile);
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element element = dom.getRootElement().element("dirToRunMaven");
        if (element != null) {
            element.detach();
            dom.getRootElement().addElement("workingPath").setText(element.getTextTrim());
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        Element root = dom.getRootElement();
        root.element("commandSuccessCondition").detach();
        root.element("environmentVariables").setName("environments");
        if (!versions.empty()) {
            versions.pop();
        } else {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("syncBuildVersion").setText("false");
    }
}

