/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.trac.step.issueupdater;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommand;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommandDef;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.AbstractCommitCommandUpdater;
import com.pmease.quickbuild.plugin.tracker.trac.TracTracker;
import com.pmease.quickbuild.plugin.tracker.trac.client.TracClient;
import com.pmease.quickbuild.plugin.tracker.trac.setting.TracCommandDef;
import com.pmease.quickbuild.plugin.tracker.trac.step.issueupdater.TracIssueUpdater;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;

@Editable(name="Update tickets according to commit commands", order=10)
public class TracCommandUpdater
extends AbstractCommitCommandUpdater
implements TracIssueUpdater {
    private static final long serialVersionUID = 1L;
    private List<TracCommandDef> commandDefs;
    private transient TracClient globalClient;

    protected void onBeforeUpdate() {
        this.globalClient = TracClient.newInstance();
    }

    protected void initCommandDefs() {
        this.commandDefs = new ArrayList<TracCommandDef>();
        this.commandDefs.add(new TracCommandDef("update", null));
        this.commandDefs.add(new TracCommandDef("accept", "status=accepted\nowner=${step.getTrackerUser()}"));
        this.commandDefs.add(new TracCommandDef("reopen", "status=reopened\nresolution="));
        this.commandDefs.add(new TracCommandDef("reassign", "status=assigned"));
        this.commandDefs.add(new TracCommandDef("fix", "status=closed\nresolution=fixed"));
    }

    @Editable(name="Commit Commands", order=1500, description="QuickBuild will search for defined commands in SCM commit messages, and update associated tickets using specified attributes. For example, if command \"fix\" is defined to set ticket status to \"closed\", occurrence of \"fix #123\" in commit messages will be interpreted as closing ticket \"#123\" in current build. Refer to <a href=\"$docroot/Commit+Command\" target=\"_blank\">command syntax</a> on how to use defined commands in commit messages.<br/><strong>NOTE:</strong> Commit commands are case-insensitive.")
    @NotEmpty
    @Size(min=1, max=1000)
    @Scriptable
    @ScriptApi
    public List<TracCommandDef> getCommandDefs() {
        return this.commandDefs;
    }

    public void setCommandDefs(List<TracCommandDef> commandDefs) {
        this.commandDefs = commandDefs;
    }

    protected AbstractIssueTracker createTracker() {
        return new TracTracker();
    }

    protected void executeCommand() {
        CommitCommand command = this.getCurrentCommand();
        Integer id = Integer.valueOf(command.getIssue());
        Issue issue = this.globalClient.getIssue(id);
        Calendar lastUpdated = issue.getUpdated();
        Date commitTime = command.getDate();
        Logger logger = Context.getLogger();
        if (this.updatedIssues.contains(command.getIssue()) && lastUpdated != null && commitTime.before(lastUpdated.getTime())) {
            throw new TrackerException("This ticket has been updated after commit.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Updating ticket [#" + id + " via command [" + command + "]");
        }
        this.globalClient.updateIssue(id, command.getOptions());
    }

    protected List<? extends CommitCommandDef> getCommitCommandDefs() {
        return this.getCommandDefs();
    }
}

