/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.trac.step.issueupdater;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.trac.client.TracClient;
import com.pmease.quickbuild.plugin.tracker.trac.step.issueupdater.AbstractTicketListUpdater;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Tickets specified by a TicketQuery", order=20)
public class FilteredTicketUpdater
extends AbstractTicketListUpdater {
    private static final long serialVersionUID = 1L;
    private String filter;

    @Editable(name="Ticket Query", description="Use the TicketQuery syntax to filter the tickets to be updated. For example: status=new&type=enhancement")
    @NotEmpty
    @Scriptable
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    protected Set<String> getIssueKeys() {
        TracClient client = TracClient.newInstance();
        Integer[] ids = client.query(this.getFilter());
        HashSet<String> result = new HashSet<String>();
        for (Integer id : ids) {
            result.add(String.valueOf(id));
        }
        return result;
    }
}

