/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.trac.step.issueprovider;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.step.issueprovider.AbstractCommitMessageProvider;
import com.pmease.quickbuild.plugin.tracker.trac.TracTracker;
import com.pmease.quickbuild.plugin.tracker.trac.client.TracClient;
import com.pmease.quickbuild.plugin.tracker.trac.step.issueprovider.TicketProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Tickets found in commit messages", order=10)
public class CommitMessageProvider
extends AbstractCommitMessageProvider
implements TicketProvider {
    private static final long serialVersionUID = 1L;
    private String ticketStatus = "closed";

    @Editable(name="Applicable Ticket Statuses", order=1100, description="Tickets appeared in SCM commit message (since previous successful build) and with specified statuses (separated by spaces) will be updated to associate with current build version via milestone field.")
    @NotEmpty
    @Scriptable
    @ScriptApi
    public String getTicketStatus() {
        return this.ticketStatus;
    }

    public void setTicketStatus(String ticketStatus) {
        this.ticketStatus = ticketStatus;
    }

    public Set<String> getIssueKeys() {
        Set keys = super.getIssueKeys();
        if (keys.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        TracClient client = TracClient.newInstance();
        HashSet<String> statuses = new HashSet<String>(Arrays.asList(StringUtils.split((String)this.getTicketStatus())));
        for (String key : keys) {
            try {
                Issue issue = client.getIssue(Integer.valueOf(key));
                String status = issue.getStatus();
                if (status == null || !statuses.contains(status.toUpperCase())) continue;
                result.add(key);
            }
            catch (TrackerException e) {
                Context.getLogger().warn("Failed to retrieve issue '" + key + "' from Trac server.", (Throwable)e);
            }
        }
        return result;
    }

    protected AbstractIssueTracker getTracker() {
        return new TracTracker();
    }
}

