/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.trac.step;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractUpdateIssueStep;
import com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.IssueUpdater;
import com.pmease.quickbuild.plugin.tracker.trac.TracPlugin;
import com.pmease.quickbuild.plugin.tracker.trac.step.issueupdater.IssueUpdaterWrapper;
import com.pmease.quickbuild.plugin.tracker.trac.step.issueupdater.TracCommandUpdater;
import com.pmease.quickbuild.plugin.tracker.trac.step.issueupdater.TracIssueUpdater;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.validation.constraints.Size;
import org.dom4j.Element;

@Editable(name="Update Trac Tickets", category={"Issue Tracker"}, description="This step will update Trac tickets based on commit commands found in SCM commit messages since previous successful build.<br/><strong>NOTE:</strong><ul class=\"square\">   <li>This step should be arranged to run before the \"release milestone\" step if you want to    release this build into Trac as milestone.</li>\t<li>Tickets will be updated under committer's Trac account. To determine Trac account     of the committer, QuickBuild first maps committer name to QuickBuild user name via user mapping setting     of the repository, and then get associated Trac account of that QuickBuild user.     If Trac account of the QuickBuild user is not specified, the QuickBuild user account will be used     to login to Trac.</li>\t<li>Tickets updated manually after commit will not be processed here.</li></ul>")
@ScriptApi(value="This step updates Trac issues based commit commands found in SCM commit messages since previous successful build.")
public class UpdateIssueStep
extends AbstractUpdateIssueStep {
    private static final long serialVersionUID = 1L;
    private List<IssueUpdaterWrapper> wrappers = new ArrayList<IssueUpdaterWrapper>();

    public UpdateIssueStep() {
        IssueUpdaterWrapper wrapper = new IssueUpdaterWrapper();
        wrapper.setUpdater(new TracCommandUpdater());
        this.wrappers.add(wrapper);
    }

    @Editable(name="Extra Attributes", order=1600, description="Optionally specify extra attributes for all commit commands, with one attribute per line. For example:<br/><code>owner=admin<br/>version=some_version</code><strong>NOTE: </strong>Attribute specified here will be overrided by the same attribute specified in commit command definition and option.<br/>Reference <a href=\"$docroot/Integrating+with+Trac\" target=\"_default\">here</a> for available attributes.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra attributes for all commit commands.")
    public String getExtraAttributes() {
        return super.getExtraAttributes();
    }

    public Class<? extends AbstractTrackerPlugin> getPluginClass() {
        return TracPlugin.class;
    }

    protected List<IssueUpdater> getUpdaters() {
        ArrayList<IssueUpdater> updaters = new ArrayList<IssueUpdater>();
        for (IssueUpdaterWrapper each : this.wrappers) {
            TracIssueUpdater updater = each.getUpdater();
            if (updater == null) continue;
            updaters.add(updater);
        }
        return updaters;
    }

    @Editable(name="Specify How to Update Issues", order=1000)
    @Size(min=1, max=10000)
    public List<IssueUpdaterWrapper> getWrappers() {
        return this.wrappers;
    }

    public void setWrappers(List<IssueUpdaterWrapper> wrappers) {
        this.wrappers = wrappers;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element commandDefsElement = dom.getRootElement().element("commandDefs");
        commandDefsElement.detach();
        Element wrappersElement = dom.getRootElement().addElement("wrappers");
        Element wrapperElement = wrappersElement.addElement("com.pmease.quickbuild.plugin.tracker.trac.step.issueupdater.IssueUpdaterWrapper");
        Element updaterElement = wrapperElement.addElement("updater");
        updaterElement.addAttribute("class", "com.pmease.quickbuild.plugin.tracker.trac.step.issueupdater.TracCommandUpdater");
        updaterElement.add(commandDefsElement);
    }
}

