/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.trac.step;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractReleaseVersionStep;
import com.pmease.quickbuild.plugin.tracker.core.step.issueprovider.IssueProvider;
import com.pmease.quickbuild.plugin.tracker.trac.TracPlugin;
import com.pmease.quickbuild.plugin.tracker.trac.TracTracker;
import com.pmease.quickbuild.plugin.tracker.trac.client.TracClient;
import com.pmease.quickbuild.plugin.tracker.trac.step.issueprovider.CommitMessageProvider;
import com.pmease.quickbuild.plugin.tracker.trac.step.issueprovider.TicketProviderWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.dom4j.Element;

@Editable(name="Release Trac Milestone", category={"Issue Tracker"}, description="This step will release the Trac milestone corresponding to current build version. Milestone will be created at Trac side if it does not already exist. Milestone field of related tickets will also be updated if necessary. ")
public class ReleaseMilestoneStep
extends AbstractReleaseVersionStep {
    private static final long serialVersionUID = 1L;
    private List<TicketProviderWrapper> wrappers = new ArrayList<TicketProviderWrapper>();
    private transient TracClient client;

    public ReleaseMilestoneStep() {
        TicketProviderWrapper wrapper = new TicketProviderWrapper();
        wrapper.setProvider(new CommitMessageProvider());
        this.wrappers.add(wrapper);
    }

    @Editable(name="Tickets to Update 'Milestone' Field", order=1000, description="Specify issues whose <i>Milestone</i> field will be updated to reflect this released milestone.")
    public List<TicketProviderWrapper> getWrappers() {
        return this.wrappers;
    }

    public void setWrappers(List<TicketProviderWrapper> wrappers) {
        this.wrappers = wrappers;
    }

    @Editable(order=1200, name="Extra Attributes", description="Specify extra attributes when update milestone field of applicable tickets, with one attribute per line. For example:<br> <code>reporter=admin<br/>version=some_version</code>Reference <a href=\"$docroot/Integrating+with+Trac\" target=\"_default\">here</a> for available attributes.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra attributes when update milestone field of applicable issues.")
    public String getExtraAttributes() {
        return super.getExtraAttributes();
    }

    public Class<? extends AbstractTrackerPlugin> getPluginClass() {
        return TracPlugin.class;
    }

    protected List<IssueProvider> getProviders() {
        ArrayList<IssueProvider> providers = new ArrayList<IssueProvider>();
        for (TicketProviderWrapper each : this.wrappers) {
            providers.add(each.getProvider());
        }
        return providers;
    }

    protected void onBeforeRelease() {
        super.onBeforeRelease();
        this.client = TracClient.newInstance();
        this.attributes.put("milestone", Context.getBuild().getVersion());
    }

    protected void releaseVersion() {
        TracClient client = TracClient.newInstance();
        String milestone = Context.getBuild().getVersion();
        Context.getLogger().info("Releasing milestone " + milestone + " ...");
        client.releaseMilestone(milestone);
    }

    protected void updateIssue(String key) {
        Integer id = Integer.valueOf(key);
        this.client.updateIssue(id, this.attributes);
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        versions.push(0);
        Element ticketStatusElement = dom.getRootElement().element("ticketStatus");
        ticketStatusElement.detach();
        Element wrappersElement = dom.getRootElement().addElement("wrappers");
        Element wrapperElement = wrappersElement.addElement("com.pmease.quickbuild.plugin.tracker.trac.step.issueprovider.TicketProviderWrapper");
        Element providerElement = wrapperElement.addElement("provider");
        providerElement.addAttribute("class", "com.pmease.quickbuild.plugin.tracker.trac.step.issueprovider.CommitMessageProvider");
        providerElement.add(ticketStatusElement);
    }

    protected IssueTracker getIssueTracker() {
        return new TracTracker();
    }
}

