/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.trac.step;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractIssueStep;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.trac.TracPlugin;
import com.pmease.quickbuild.plugin.tracker.trac.client.TracClient;
import com.pmease.quickbuild.plugin.tracker.trac.setting.TracSetting;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Create Trac Ticket", category={"Issue Tracker"}, description="This step create a Trac ticket based on your step condition")
public class CreateIssueStep
extends AbstractIssueStep {
    private static final long serialVersionUID = 1L;
    private String issueType;
    private String summary;
    private String description;
    private String priority;

    @Editable(name="Ticket Type", order=1100, description="Specify the ticket type")
    @ExpressionProvider(value="getAvailableTypes")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get ticket type.")
    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    @Editable(name="Ticket Summary", order=1200, description="Specify the issue summary")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get issue summary.")
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String issueSummary) {
        this.summary = issueSummary;
    }

    @Editable(name="Ticket Description", order=1300, description="Optionally specify the issue description")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get issue description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String issueDescription) {
        this.description = issueDescription;
    }

    @Editable(name="Ticket Priority", order=1400, description="Optionally specify the issue priority")
    @ExpressionProvider(value="getAvailablePriorities")
    @Scriptable
    @ScriptApi(value="Get issue priority.")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String issuePriority) {
        this.priority = issuePriority;
    }

    @Editable(order=1600, name="Extra Attributes", description="Optionally specify extra attributes of the ticket, with one attribute per line. For example:<br/><code>owner=admin<br/>version=some_version</code><strong>NOTE:</strong> Attributes specified here should have been defined by your Trac administrator.<br/>Reference <a href=\"$docroot/Integrating+with+Trac\" target=\"_default\">here</a> for available attributes.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra command options which will be used create the issue.")
    public String getExtraAttributes() {
        return super.getExtraAttributes();
    }

    private static Map<String, String> getAvailableTypes() {
        if (!TracSetting.isApplicable()) {
            return Collections.emptyMap();
        }
        TracClient client = TracClient.newInstance();
        String[] types = client.getAllTypes();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String each : types) {
            map.put(each, each);
        }
        return map;
    }

    private static Map<String, String> getAvailablePriorities() {
        if (!TracSetting.isApplicable()) {
            return Collections.emptyMap();
        }
        TracClient client = TracClient.newInstance();
        String[] types = client.getAllPriorities();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String each : types) {
            map.put(each, each);
        }
        return map;
    }

    public void run() {
        this.onBeforeRun();
        Map map = StringHelper.getOptionsFromDefinition((String)this.getExtraAttributes());
        map.put("type", this.getIssueType());
        map.put("priority", this.getPriority());
        TracClient client = TracClient.newInstance();
        Integer id = client.createIssue(this.getSummary(), this.getDescription(), map);
        this.getIssueActions().put(String.valueOf(id), "create");
        Context.getLogger().info("Ticket #" + id + "[" + this.getSummary() + "] created! ");
        this.onAfterRun();
    }

    public Class<? extends AbstractTrackerPlugin> getPluginClass() {
        return TracPlugin.class;
    }
}

