/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.trac.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.tracker.core.setting.AbstractTrackerSetting;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.trac.TracPlugin;
import com.pmease.quickbuild.plugin.tracker.trac.client.TracClient;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Trac Server", order=1010, category={"Issue Tracker"})
public class TracSetting
extends AbstractTrackerSetting {
    private static final long serialVersionUID = 1L;

    public TracSetting() {
        this.setIssuePattern("(?<!\\:)(?:#|ticket:)\\d+");
    }

    public TracSetting(String host, String user, String password) {
        this.setHost(host);
        this.setUser(user);
        this.setPassword(password);
        this.setIssuePattern("(?<!\\:)(?:#|ticket:)\\d+");
    }

    public static TracSetting get(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        return (TracSetting)((Object)PluginSettingHelper.findConfigurationSetting(TracPlugin.class, (Configuration)configuration, (boolean)true));
    }

    public static boolean isApplicable() {
        return TracSetting.get(Context.getConfiguration()) != null;
    }

    @Editable(order=200, name="Trac Project Url", description="Specify the Trac url corresponding to current configuration. For example: http://trac-server/myproject.")
    @NotEmpty
    @Scriptable
    @ScriptApi
    public String getHost() {
        return super.getHost();
    }

    @Editable(name="Trac Ticket Pattern", order=1100, description="Specify <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">pattern</a> of Trac ticket keys in SCM commit message. This pattern will be used by QuickBuild to transform ticket keys into ticket links. If the default pattern is used, <i>#123</i> and <i>ticket:123</i> will be recognized as ticket keys while <i>:#123</i> will not.")
    @NotEmpty
    @Scriptable
    @ScriptApi
    public String getIssuePattern() {
        return super.getIssuePattern();
    }

    public String getIssueUrlPattern() {
        return StringHelper.normalizeUrl((String)this.getHost()) + "/ticket/$KEY";
    }

    @ScriptApi(value="Get all unreleased milestones from Trac.")
    public List<String> getUnreleasedMilestones() {
        return this.getUnreleasedMilestones(null);
    }

    @ScriptApi(value="Use <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">Java regular expression</a> to match the unreleased milestones from Trac.")
    public List<String> getUnreleasedMilestones(String pattern) {
        TracClient client = TracClient.newInstance();
        List<String> unreleased = client.getUnreleasedMilestones();
        if (StringUtils.isEmpty((String)pattern)) {
            return unreleased;
        }
        Pattern pVersion = Pattern.compile(pattern);
        ArrayList<String> result = new ArrayList<String>();
        for (String each : unreleased) {
            Matcher m = pVersion.matcher(each);
            if (!m.find()) continue;
            result.add(each);
        }
        return result;
    }

    @ScriptApi(value="Get next unreleased milestone from Trac.")
    public String getNextUnreleasedMilestone() {
        return this.getNextUnreleasedMilestone(null);
    }

    @ScriptApi(value="Use <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">Java regular expression</a> to match next unreleased milestone from Trac.")
    public String getNextUnreleasedMilestone(String pattern) {
        List<String> unreleased = this.getUnreleasedMilestones(pattern);
        if (unreleased.isEmpty()) {
            throw new QuickbuildException("Unable to find unreleased milestone matching specified pattern.");
        }
        return unreleased.get(0);
    }
}

