/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.trac.client;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.validator.routines.DateValidator;
import org.apache.ws.commons.util.NamespaceContextImpl;
import org.apache.xmlrpc.common.TypeFactoryImpl;
import org.apache.xmlrpc.common.XmlRpcController;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.parser.DateParser;
import org.apache.xmlrpc.parser.TypeParser;
import org.apache.xmlrpc.serializer.TypeSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TracTypeFactory
extends TypeFactoryImpl {
    public TracTypeFactory(XmlRpcController pController) {
        super(pController);
    }

    protected DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    }

    public TypeParser getParser(XmlRpcStreamConfig pConfig, NamespaceContextImpl pContext, String pURI, String pLocalName) {
        if ("dateTime.iso8601".equals(pLocalName)) {
            return new DateParser((Format)this.getDateFormat());
        }
        return super.getParser(pConfig, pContext, pURI, pLocalName);
    }

    public TypeSerializer getSerializer(XmlRpcStreamConfig pConfig, Object pObject) throws SAXException {
        if (pObject instanceof Date) {
            return new DateSerializer();
        }
        return super.getSerializer(pConfig, pObject);
    }

    class DateSerializer
    extends org.apache.xmlrpc.serializer.DateSerializer {
        public DateSerializer() {
            super(null);
        }

        public void write(ContentHandler pHandler, Object pObject) throws SAXException {
            String str = "";
            if (pObject != null && pObject instanceof Date) {
                str = DateValidator.getInstance().format(pObject, "yyyyMMdd'T'H:m:s", TimeZone.getTimeZone("GMT"));
            }
            this.write(pHandler, "dateTime.iso8601", str);
        }
    }
}

