/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.trac.client;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.trac.client.RemoteMilestone;
import com.pmease.quickbuild.plugin.tracker.trac.client.TracTypeFactory;
import com.pmease.quickbuild.plugin.tracker.trac.setting.TracSetting;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;

public class TracClient {
    private final TracSetting server;
    private final XmlRpcClient client;

    public TracClient(TracSetting server) {
        this.server = server;
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            config.setServerURL(new URL(this.getRpcUrl()));
            config.setBasicUserName(server.getUser());
            config.setBasicPassword(server.getPassword());
            this.client = new XmlRpcClient();
            this.client.setConfig((XmlRpcClientConfig)config);
            this.client.setTypeFactory((TypeFactory)new TracTypeFactory((XmlRpcController)this.client));
        }
        catch (MalformedURLException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public TracClient(String host, String user, String password) {
        this(new TracSetting(host, user, password));
    }

    public static TracClient newInstance() {
        if (TracSetting.isApplicable()) {
            return new TracClient(TracSetting.get(Context.getConfiguration()));
        }
        throw new TrackerException("Configuration " + Context.getConfiguration().getPathName() + " has no Trac setting or the setting is not configured properly.");
    }

    public Issue getNullableIssue(Integer id) {
        try {
            return this.getIssue(id);
        }
        catch (TrackerException e) {
            return null;
        }
    }

    public Issue getIssue(Integer id) {
        Object[] array = (Object[])this.execute("ticket.get", id);
        return TracClient.toIssue(array);
    }

    public int deleteIssue(Integer id) {
        return (Integer)this.execute("ticket.delete", id);
    }

    public String[] getActions(Integer id) {
        Object[] actions = this.getArrayResult("ticket.getActions", new Object[]{id});
        String[] result = new String[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            Object[] action = (Object[])actions[i];
            result[i] = (String)action[0];
        }
        return result;
    }

    public Integer createIssue(String summary, String description, Map attributes) {
        Integer id;
        if (StringUtils.isEmpty((String)description)) {
            description = "";
        }
        if ((id = (Integer)this.execute("ticket.create", summary, description, attributes)) == null) {
            throw new TrackerException("Unable to create ticket [" + summary + "].");
        }
        String comment = (String)attributes.get("comment");
        if (!StringUtils.isEmpty((String)comment)) {
            this.addComment(id, comment);
        }
        return id;
    }

    public Integer[] query(String query) {
        Object[] result = (Object[])this.execute("ticket.query", query);
        if (result == null) {
            return new Integer[0];
        }
        Integer[] ids = new Integer[result.length];
        for (int i = 0; i < result.length; ++i) {
            ids[i] = (Integer)result[i];
        }
        return ids;
    }

    public void updateIssue(Integer id, Map attributes) {
        String comment = (String)attributes.get("comment");
        if (comment == null) {
            comment = "";
        }
        attributes.remove("comment");
        String action = (String)attributes.get("action");
        if (StringUtils.isEmpty((String)action) || "leave".equalsIgnoreCase(action) || "update".equalsIgnoreCase(action)) {
            attributes.remove("action");
        }
        try {
            this.execute("ticket.update", id, comment, attributes);
        }
        catch (TrackerException e) {
            try {
                Thread.sleep(1000L);
                this.execute("ticket.update", id, comment, attributes);
            }
            catch (InterruptedException e1) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e1);
            }
        }
    }

    public void progressIssue(Integer id, String action, Map map) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put("action", action);
        this.updateIssue(id, map);
    }

    public void addComment(Integer id, String comment) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("comment", comment);
        this.updateIssue(id, map);
    }

    public String[] getTicketFields() {
        Object[] array = this.getArrayResult("ticket.getTicketFields");
        if (array == null) {
            return new String[0];
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            HashMap map = (HashMap)array[i];
            result[i] = (String)map.get("name");
        }
        return result;
    }

    public void createMilestone(String milestone, Map attributes) {
        this.execute("ticket.milestone.create", milestone, attributes);
    }

    public void updateMilestone(String milestone, Map attributes) {
        this.execute("ticket.milestone.update", milestone, attributes);
    }

    public void releaseMilestone(String version) {
        Object[] all = this.getAllMilestones();
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("completed", new Date());
        if (ArrayUtils.contains((Object[])all, (Object)version)) {
            this.updateMilestone(version, map);
        } else {
            this.createMilestone(version, map);
        }
    }

    public String[] getAllMilestones() {
        return this.getStringArray("ticket.milestone.getAll");
    }

    public RemoteMilestone getMilestone(String name) {
        Map milestone = (Map)this.execute("ticket.milestone.get", name);
        return new RemoteMilestone(milestone);
    }

    public List<String> getUnreleasedMilestones() {
        String[] milestones = this.getAllMilestones();
        ArrayList<String> result = new ArrayList<String>();
        for (String each : milestones) {
            RemoteMilestone milestone = this.getMilestone(each);
            if (milestone == null || milestone.isCompleted()) continue;
            result.add(each);
        }
        return result;
    }

    public void getAllComponents() {
        this.getArrayResult("ticket.component.getAll");
    }

    public void getComponent(String name) {
        this.execute("ticket.component.get", name);
    }

    public void deleteComponent(String name) {
        this.execute("ticket.component.delete", name);
    }

    public void updateComponent(String name, Map attributes) {
        this.execute("ticket.component.update", name, attributes);
    }

    public String[] getAllStatus() {
        return this.getStringArray("ticket.status.getAll");
    }

    public String[] getAllPriorities() {
        return this.getStringArray("ticket.priority.getAll");
    }

    public String[] getAllResolution() {
        return this.getStringArray("ticket.resolution.getAll");
    }

    public String[] getAllSeverity() {
        return this.getStringArray("ticket.severity.getAll");
    }

    public String[] getAllTypes() {
        return this.getStringArray("ticket.type.getAll");
    }

    protected String getRpcUrl() {
        return StringHelper.normalizeUrl((String)this.server.getHost()) + "/login/xmlrpc";
    }

    protected Object execute(String method, Object ... params) {
        try {
            return this.client.execute(method, params);
        }
        catch (XmlRpcException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    protected static Issue toIssue(Object[] array) {
        if (array == null || array.length < 4) {
            return null;
        }
        Issue issue = new Issue();
        issue.setIssueKey(String.valueOf(array[0]));
        issue.setCreated((Calendar)DataTypes.TIME.typeCast(array[1]));
        issue.setUpdated((Calendar)DataTypes.TIME.typeCast(array[2]));
        HashMap attributes = (HashMap)array[3];
        issue.setAssignee((String)attributes.get("owner"));
        issue.setSummary((String)attributes.get("summary"));
        issue.setReporter((String)attributes.get("reporter"));
        issue.setIssueType((String)attributes.get("type"));
        issue.setPriority((String)attributes.get("priority"));
        issue.setStatus((String)attributes.get("status"));
        issue.setResolution((String)attributes.get("resolution"));
        return issue;
    }

    private static String[] objectArrayToStringArray(Object[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (String)array[i];
        }
        return result;
    }

    protected Object[] getArrayResult(String method) {
        return this.getArrayResult(method, new Object[0]);
    }

    protected Object[] getArrayResult(String method, Object[] params) {
        return (Object[])this.execute(method, params);
    }

    protected String[] getStringArray(String method, Object[] params) {
        return TracClient.objectArrayToStringArray(this.getArrayResult(method, params));
    }

    protected String[] getStringArray(String method) {
        return this.getStringArray(method, new Object[0]);
    }

    public static enum Action {
        CREATEISSUE("create"),
        UPDATEISSUE("update");

        String command;

        private Action(String command) {
            this.command = command;
        }
    }
}

