/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.trac;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.trac.setting.TracSetting;
import com.pmease.quickbuild.setting.configuration.version.VersionManager;

@Editable(name="Use first unreleased milestone from Trac")
public class TracVersionManager
extends VersionManager {
    private static final long serialVersionUID = 1L;
    private String pattern;

    @Editable(name="Milestone Pattern", description="If this property is specified, the first unreleased milestone matching this <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">pattern</a> will be used as next build version. For example, the pattern \"2\\.0\\..*\" (period character is escaped since it has special meaning in Java pattern) tells QuickBuild to use first unreleased milestone starting with \"2.0\".")
    @Scriptable
    @ScriptApi(value="Get pattern of unreleased milestones.")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getNext() {
        TracSetting setting = TracSetting.get(Context.getConfiguration());
        return setting.getNextUnreleasedMilestone(this.getPattern());
    }
}

