/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.trac;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.plugin.tracker.trac.TracPlugin;
import com.pmease.quickbuild.plugin.tracker.trac.client.TracClient;
import com.pmease.quickbuild.plugin.tracker.trac.setting.TracSetting;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class TracTracker
extends AbstractIssueTracker {
    private static final long serialVersionUID = 1L;

    public String getIssueUrlPattern() {
        return TracSetting.get(Context.getConfiguration()).getIssueUrlPattern();
    }

    public String extractIssueKey(String matched) {
        Long id = TrackerHelper.extractLong((String)matched);
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    protected Class<? extends AbstractTrackerPlugin> getTrackerPluginClass() {
        return TracPlugin.class;
    }

    public Map<String, Issue> fetchIssues(Collection<String> keys) {
        return this.fetchIssues(keys, true);
    }

    public Map<String, Issue> fetchIssues(Collection<String> keys, boolean nullable) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Issue> issues = new LinkedHashMap<String, Issue>();
        TracClient client = TracClient.newInstance();
        for (String key : keys) {
            Integer id = Integer.valueOf(this.extractIssueKey(key));
            Issue issue = nullable ? client.getNullableIssue(id) : client.getIssue(id);
            if (issue == null) continue;
            issues.put(key, issue);
        }
        return issues;
    }
}

