/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.web.components;

import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.web.component.AjaxTextLink;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public abstract class TimeSpanButtonGroup
extends Panel {
    private TimeSpan timespan;
    static final TimeSpan[] PERIODS = new TimeSpan[]{TimeSpan.LAST_HOUR, TimeSpan.LAST_2_HOURS, TimeSpan.LAST_4_HOURS, TimeSpan.LAST_DAY, TimeSpan.LAST_WEEK, TimeSpan.LAST_MONTH};

    public TimeSpanButtonGroup(String id, TimeSpan timespan) {
        super(id);
        this.timespan = timespan;
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.newPeriodButtons("periods")});
    }

    protected TimeSpan[] getTimeSpans() {
        return PERIODS;
    }

    protected Component newPeriodButtons(String id) {
        return new Loop(id, (IModel)new AbstractReadOnlyModel<Integer>(){

            public Integer getObject() {
                return PERIODS.length;
            }
        }){

            protected void populateItem(LoopItem item) {
                final int i = item.getIndex();
                AjaxTextLink<Void> link = new AjaxTextLink<Void>("link", PERIODS[i].getDisplayName()){

                    public void onClick(AjaxRequestTarget target) {
                        TimeSpan span = PERIODS[i];
                        if (span == TimeSpanButtonGroup.this.timespan) {
                            return;
                        }
                        TimeSpanButtonGroup.this.timespan = span;
                        TimeSpanButtonGroup.this.onTimeSpanChanged(target, span);
                    }
                };
                link.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return PERIODS[i] == TimeSpanButtonGroup.this.timespan ? "checked" : "";
                    }
                })});
                item.add(new Component[]{link});
            }
        };
    }

    protected abstract void onTimeSpanChanged(AjaxRequestTarget var1, TimeSpan var2);
}

