/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.web.components;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.WildcardListModel;

public class ListDataProvider<T extends Serializable>
extends SortableDataProvider<T> {
    private static final long serialVersionUID = 1L;
    private final IModel<List<T>> listModel;

    public ListDataProvider(List<T> list) {
        this.listModel = new WildcardListModel(list);
    }

    public ListDataProvider(IModel<List<T>> listModel) {
        this.listModel = listModel;
    }

    public Iterator<T> iterator(int first, int count) {
        List<T> list = this.getList();
        if (list.isEmpty()) {
            return list.iterator();
        }
        ImmutableList result = ImmutableList.copyOf(list.subList(first, first + count));
        return result.iterator();
    }

    public IModel<T> model(T item) {
        return Model.of(item);
    }

    public int size() {
        return this.getList().size();
    }

    protected List<T> getList() {
        return this.listModel == null ? ImmutableList.of() : (List)this.listModel.getObject();
    }

    protected void onDetach() {
        if (this.listModel != null) {
            this.listModel.detach();
        }
    }
}

