/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.web;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.pmease.quickbuild.entitymanager.AlertManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertDefinition;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertSetting;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.alert.engine.web.components.PriorityLabel;
import com.pmease.quickbuild.plugin.alert.engine.web.components.TimeSpanButtonGroup;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.web.component.datatablesupport.EntityColumn;
import com.pmease.quickbuild.web.component.datatablesupport.EntityDataTable;
import com.pmease.quickbuild.web.component.datatablesupport.FilterableEntityProvider;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchNavToolbar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class AlertPanel
extends Panel {
    private final IModel<AlertSetting> settingModel;
    private TimeSpan timespan = TimeSpan.LAST_HOUR;
    static final TimeSpan[] PERIODS = new TimeSpan[]{TimeSpan.LAST_HOUR, TimeSpan.LAST_2_HOURS, TimeSpan.LAST_4_HOURS, TimeSpan.LAST_DAY, TimeSpan.LAST_WEEK, TimeSpan.LAST_MONTH};
    private String source = "All";
    private String priority = "All";
    private String definition = "All";

    public AlertPanel(String id) {
        super(id);
        this.settingModel = new LoadableDetachableModel<AlertSetting>(){

            protected AlertSetting load() {
                return AlertSetting.get();
            }
        };
        this.setOutputMarkupId(true);
    }

    private AlertSetting getPluginSetting() {
        return (AlertSetting)this.settingModel.getObject();
    }

    protected Component newPeriodButtons(String id) {
        return new TimeSpanButtonGroup(id, this.timespan){

            @Override
            protected void onTimeSpanChanged(AjaxRequestTarget target, TimeSpan timespan) {
                AlertPanel.this.timespan = timespan;
                AlertPanel.this.onSettingChanged(target);
            }
        };
    }

    private void onSettingChanged(AjaxRequestTarget target) {
        this.addOrReplace(new Component[]{this.newPeriodButtons("periods")});
        DataTable dataTable = (DataTable)this.get("alerts");
        dataTable.setCurrentPage(0);
        target.add(new Component[]{this});
    }

    private Component createAlertsTable(String id) {
        FilterableEntityProvider provider = new FilterableEntityProvider(Alert.class, new SortParam("ctime", false), new String[]{"subject", "trigger"}){

            public Criterion[] getCriterions() {
                Object[] crits;
                ArrayList list = Lists.newArrayList();
                Range<Long> range = AlertPanel.this.timespan.range();
                list.add(Restrictions.ge((String)"ctime", (Object)range.lowerEndpoint()));
                list.add(Restrictions.le((String)"ctime", (Object)range.upperEndpoint()));
                if (!Objects.equal((Object)"All", (Object)AlertPanel.this.priority)) {
                    list.add(Restrictions.eq((String)"priority", (Object)Alert.AlertPriority.valueOf((String)AlertPanel.this.priority)));
                }
                if (!Objects.equal((Object)"All", (Object)AlertPanel.this.source)) {
                    list.add(Restrictions.eq((String)"trigger", (Object)AlertPanel.this.source));
                }
                if (!Objects.equal((Object)"All", (Object)AlertPanel.this.definition)) {
                    list.add(Restrictions.eq((String)"subject", (Object)AlertPanel.this.definition));
                }
                if ((crits = super.getCriterions()) != null) {
                    list.addAll(Lists.newArrayList((Object[])crits));
                }
                return (Criterion[])Iterables.toArray((Iterable)list, Criterion.class);
            }
        };
        EntityDataTable dataTable = new EntityDataTable(id, this.getTableColumns(), provider, 50);
        dataTable.addTopToolbar((AbstractToolbar)new SearchNavToolbar((DataTable)dataTable));
        dataTable.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar((DataTable)dataTable, (ISortStateLocator)provider));
        dataTable.addBottomToolbar((AbstractToolbar)new SearchNavToolbar((DataTable)dataTable));
        return dataTable;
    }

    private List<IColumn<Long>> getTableColumns() {
        ArrayList columns = Lists.newArrayList();
        columns.add(new EntityColumn(Alert.class, "priority", true){

            protected Component createItemComponent(String componentId, IModel<Long> rowModel) {
                Alert alert = (Alert)AlertManager.instance.load((Long)rowModel.getObject());
                Alert.AlertPriority priority = alert.getPriority();
                return new PriorityLabel(componentId, priority);
            }
        }.setCssClass("enum"));
        columns.add(new EntityColumn(Alert.class, "subject", true).setCssClass("nowrap-text"));
        columns.add(new EntityColumn(Alert.class, "trigger", true).setCssClass("nowrap-text"));
        columns.add(new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Condition Test"))){

            public void populateItem(Item<ICellPopulator<Long>> item, String componentId, IModel<Long> rowModel) {
                Long id = (Long)rowModel.getObject();
                Alert alert = (Alert)AlertManager.instance.load(id);
                if (alert.getCategory() != Alert.AlertCategory.METRIC) {
                    item.add(new Component[]{new Label(componentId, "")});
                } else {
                    AlertSetting setting = AlertPanel.this.getPluginSetting();
                    AlertDefinition def = setting.getDefinition(alert.getSubject());
                    item.add(new Component[]{new Label(componentId, def == null ? "" : def.getCondition().toString())});
                }
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Alert Message"))){

            public void populateItem(Item<ICellPopulator<Long>> item, String id, IModel<Long> rowModel) {
                Alert alert = (Alert)AlertManager.instance.load((Long)rowModel.getObject());
                String msg = alert.getAlertMessage();
                item.add(new Component[]{new Label(id, msg)});
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Creation Time")), "ctime"){

            public void populateItem(Item<ICellPopulator<Long>> item, String id, IModel<Long> rowModel) {
                Alert alert = (Alert)AlertManager.instance.load((Long)rowModel.getObject());
                item.add(new Component[]{new Label(id, DataTypes.DATE.asString((Object)new Date(alert.getCtime()), "MMM dd, yyyy HH:mm:ss"))});
            }

            public String getCssClass() {
                return "nowrap-text";
            }
        });
        return columns;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new FilterForm("filterForm")});
        this.add(new Component[]{this.newPeriodButtons("periods")});
        this.add(new Component[]{this.createAlertsTable("alerts")});
    }

    public void onDetach() {
        if (this.settingModel != null) {
            this.settingModel.detach();
        }
        super.onDetach();
    }

    private class FilterForm
    extends Form<Void> {
        public FilterForm(String id) {
            super(id);
        }

        protected void onInitialize() {
            super.onInitialize();
            AbstractReadOnlyModel<List<String>> sourceModel = new AbstractReadOnlyModel<List<String>>(){

                public List<String> getObject() {
                    ArrayList nodes = Lists.newArrayList((Iterable)Grid.instance.getAllNodes());
                    ArrayList list = Lists.newArrayList();
                    list.add("All");
                    for (GridNode each : nodes) {
                        list.add(each.getAddress());
                    }
                    return list;
                }
            };
            DropDownChoice sourceChoice = new DropDownChoice("source", (IModel)new PropertyModel((Object)AlertPanel.this, "source"), (IModel)sourceModel);
            this.add(new Component[]{sourceChoice});
            sourceChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                protected void onUpdate(AjaxRequestTarget target) {
                    AlertPanel.this.onSettingChanged(target);
                }
            }});
            DropDownChoice priorityChoice = new DropDownChoice("priority", (IModel)new PropertyModel((Object)AlertPanel.this, "priority"), this.getPriorityList());
            this.add(new Component[]{priorityChoice});
            priorityChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                protected void onUpdate(AjaxRequestTarget target) {
                    AlertPanel.this.onSettingChanged(target);
                }
            }});
            DropDownChoice defChoice = new DropDownChoice("definition", (IModel)new PropertyModel((Object)AlertPanel.this, "definition"), this.getAllDefNames());
            this.add(new Component[]{defChoice});
            defChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                protected void onUpdate(AjaxRequestTarget target) {
                    AlertPanel.this.onSettingChanged(target);
                }
            }});
        }

        private List<String> getPriorityList() {
            ArrayList list = Lists.newArrayList();
            list.add("All");
            for (Alert.AlertPriority each : Alert.AlertPriority.values()) {
                list.add(each.name());
            }
            return list;
        }

        private List<String> getAllDefNames() {
            AlertSetting setting = AlertSetting.get();
            ArrayList list = Lists.newArrayList();
            list.add("All");
            for (AlertDefinition each : setting.getDefinitions()) {
                list.add(each.getName());
            }
            return list;
        }
    }
}

