/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.util;

import com.google.common.collect.Range;
import com.pmease.quickbuild.util.TimeUtils;

public enum TimeSpan {
    LAST_HOUR("1 hour", true){

        @Override
        public Range<Long> range() {
            return Range.closed((Comparable)Long.valueOf(TimeUtils.ago((long)3600000L)), (Comparable)Long.valueOf(System.currentTimeMillis()));
        }
    }
    ,
    LAST_2_HOURS("2 hours", true){

        @Override
        public Range<Long> range() {
            return Range.closed((Comparable)Long.valueOf(TimeUtils.ago((long)0x6DDD00L)), (Comparable)Long.valueOf(System.currentTimeMillis()));
        }
    }
    ,
    LAST_4_HOURS("4 hours", true){

        @Override
        public Range<Long> range() {
            return Range.closed((Comparable)Long.valueOf(TimeUtils.ago((long)14400000L)), (Comparable)Long.valueOf(System.currentTimeMillis()));
        }
    }
    ,
    LAST_DAY("day", true){

        @Override
        public Range<Long> range() {
            return Range.closed((Comparable)Long.valueOf(TimeUtils.ago((long)86400000L)), (Comparable)Long.valueOf(System.currentTimeMillis()));
        }
    }
    ,
    LAST_WEEK("week", false){

        @Override
        public Range<Long> range() {
            return Range.closed((Comparable)Long.valueOf(TimeUtils.ago((long)604800000L)), (Comparable)Long.valueOf(System.currentTimeMillis()));
        }
    }
    ,
    LAST_MONTH("month", false){

        @Override
        public Range<Long> range() {
            return Range.closed((Comparable)Long.valueOf(TimeUtils.ago((long)2592000000L)), (Comparable)Long.valueOf(System.currentTimeMillis()));
        }
    }
    ,
    CUSTOM("Custom Period", false){

        @Override
        public Range<Long> range() {
            return null;
        }
    };

    final String displayName;
    final boolean upperAlign;

    private TimeSpan(String displayName, boolean upperAlign) {
        this.displayName = displayName;
        this.upperAlign = upperAlign;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isUpperAlign() {
        return this.upperAlign;
    }

    public abstract Range<Long> range();
}

