/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.util;

import com.google.common.base.Objects;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;
import com.pmease.quickbuild.util.OsType;
import java.util.Locale;

public class OsTypeMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    final OsType osType;

    public OsTypeMatcher(OsType osType) {
        this.osType = osType;
    }

    @Override
    public boolean matches(GridNode node) {
        OsType current = OsType.fromOsName((String)node.getAttribute("os.name", "").toLowerCase(Locale.US));
        return current == this.osType;
    }

    public boolean equlas(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OsTypeMatcher)) {
            return false;
        }
        OsTypeMatcher rhs = (OsTypeMatcher)other;
        return Objects.equal((Object)this.osType, (Object)rhs.osType);
    }

    public OsType getOsType() {
        return this.osType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.osType});
    }

    public String toString() {
        return "Os type = " + this.osType.getDisplayName();
    }

    @Override
    public String getName() {
        return "OSTYPE";
    }

    @Override
    public String toHtml() {
        return this.toString();
    }

    @Override
    public boolean isValid() {
        return this.osType != null;
    }
}

