/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.strategy;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.alert.engine.strategy.AlertEvent;
import com.pmease.quickbuild.plugin.alert.engine.strategy.AlertEventBuffer;
import com.pmease.quickbuild.plugin.alert.engine.strategy.ConsecutiveStrategy;
import java.util.List;
import org.hibernate.validator.constraints.Range;

@Editable(name="If condition set is true X times out of the last Y times it is evaluated")
public class PartialCountStrategy
extends ConsecutiveStrategy {
    private static final long serialVersionUID = 1L;
    private int satisfiedCount;

    @Override
    @Editable(name="Y", order=200)
    @Range(min=0L, max=1024L)
    public int getCheckCount() {
        return super.getCheckCount();
    }

    @Editable(name="X", order=100)
    @Range(min=0L, max=1024L)
    public int getSatisfiedCount() {
        return this.satisfiedCount;
    }

    public void setSatisfiedCount(int satisfiedCount) {
        this.satisfiedCount = satisfiedCount;
    }

    @Override
    public boolean satisfies(AlertEventBuffer buffer) {
        List list = buffer.getLastN(this.getCheckCount());
        int satisfied = 0;
        int setCount = 0;
        for (AlertEvent each : list) {
            if (each.getEventType() != AlertEvent.EventType.UNSET) {
                ++setCount;
            }
            if (each.getEventType() != AlertEvent.EventType.MATCH) continue;
            ++satisfied;
        }
        return setCount >= this.getCheckCount() && satisfied >= this.satisfiedCount;
    }

    @Override
    public String toString() {
        return this.satisfiedCount + " times out of the last " + this.getCheckCount() + " times it is evaluated";
    }
}

