/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.strategy;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.alert.engine.strategy.AlertEvent;
import com.pmease.quickbuild.plugin.alert.engine.strategy.AlertEventBuffer;
import com.pmease.quickbuild.plugin.alert.engine.strategy.AlertFiringStrategy;
import java.util.List;
import org.hibernate.validator.constraints.Range;

@Editable(name="If condition set is true X times consecutively")
public class ConsecutiveStrategy
implements AlertFiringStrategy {
    private static final long serialVersionUID = 1L;
    private int checkCount = 5;

    @Override
    @Editable(name="Consecutive times")
    @Range(min=0L, max=1024L)
    public int getCheckCount() {
        return this.checkCount;
    }

    public void setCheckCount(int checkCount) {
        this.checkCount = checkCount;
    }

    @Override
    public boolean satisfies(AlertEventBuffer buffer) {
        List list = buffer.getLastN(this.getCheckCount());
        if (list.isEmpty()) {
            return false;
        }
        for (AlertEvent event : list) {
            if (event.getEventType() == AlertEvent.EventType.MATCH) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.checkCount + " times consecutively";
    }
}

