/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.setting;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.alert.engine.AlertPlugin;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertDefinition;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class AlertSetting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<AlertDefinition> definitions = Lists.newArrayList();

    @Nullable
    public static AlertSetting get() {
        if (AlertPlugin.get().isEnabled()) {
            return AlertSetting.get(true);
        }
        return null;
    }

    public static AlertSetting get(boolean interpolate) {
        return (AlertSetting)PluginSettingHelper.getSetting(AlertPlugin.class, (boolean)interpolate);
    }

    @Editable(name="Alert Definitions", order=200)
    public List<AlertDefinition> getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(List<AlertDefinition> definitions) {
        this.definitions = definitions;
    }

    public boolean hasName(String name) {
        AlertDefinition def = this.getDefinition(name);
        return def != null;
    }

    @Nullable
    public AlertDefinition getDefinition(String name) {
        for (AlertDefinition each : this.definitions) {
            if (!each.getName().equalsIgnoreCase(name)) continue;
            return each;
        }
        return null;
    }

    public void addDefintion(AlertDefinition definition) {
        int found = -1;
        for (int i = 0; i < this.definitions.size(); ++i) {
            AlertDefinition each = this.definitions.get(i);
            if (!Objects.equal((Object)each, (Object)definition)) continue;
            found = i;
            break;
        }
        if (found >= 0) {
            throw new IllegalArgumentException("Definition already exists");
        }
        this.definitions.add(definition);
    }

    public void updateDefinition(AlertDefinition definition, int index) {
        if (index < 0) {
            this.addDefintion(definition);
        } else {
            this.definitions.set(index, definition);
        }
    }

    public int getDefintionIndex(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return -1;
        }
        int i = 0;
        for (AlertDefinition each : this.getDefinitions()) {
            if (name.equalsIgnoreCase(each.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeDefinition(AlertDefinition definition) {
        if (definition == null) {
            return;
        }
        Iterator<AlertDefinition> it = this.definitions.iterator();
        while (it.hasNext()) {
            AlertDefinition each = it.next();
            if (!Objects.equal((Object)each, (Object)definition)) continue;
            it.remove();
            break;
        }
    }

    public void save() {
        PluginSettingHelper.saveSetting(AlertPlugin.class, (Object)this);
    }
}

