/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.setting;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.alert.engine.condition.AlertCondition;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertDefinition;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertDefinitionPanel;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertSetting;
import com.pmease.quickbuild.plugin.alert.engine.setting.PanelModeChanged;
import com.pmease.quickbuild.plugin.alert.engine.strategy.AlertFiringStrategy;
import com.pmease.quickbuild.plugin.alert.engine.web.components.ListDataProvider;
import com.pmease.quickbuild.plugin.alert.engine.web.components.PriorityLabel;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class AlertDefinitionView
extends Panel {
    private SelectionColumn<AlertDefinition> selectionColumn;

    public AlertDefinitionView(String id) {
        super(id);
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        ArrayList columns = Lists.newArrayList();
        this.selectionColumn = new SelectionColumn();
        columns.add(this.selectionColumn);
        columns.add(new AbstractColumn<AlertDefinition>((IModel)Model.of((Serializable)((Object)"P"))){

            public void populateItem(Item<ICellPopulator<AlertDefinition>> item, String id, IModel<AlertDefinition> rowModel) {
                AlertDefinition def = (AlertDefinition)rowModel.getObject();
                PriorityLabel c = new PriorityLabel(id, def.getPriority());
                item.add(new Component[]{c});
            }

            public String getCssClass() {
                return "enum";
            }
        });
        columns.add(new AbstractColumn<AlertDefinition>((IModel)Model.of((Serializable)((Object)"S"))){

            public void populateItem(Item<ICellPopulator<AlertDefinition>> item, String id, IModel<AlertDefinition> rowModel) {
                final AlertDefinition def = (AlertDefinition)rowModel.getObject();
                Fragment frag = new Fragment(id, "statusfrag", (MarkupContainer)AlertDefinitionView.this);
                AjaxLink<Void> link = new AjaxLink<Void>("enablelink"){

                    public void onClick(AjaxRequestTarget target) {
                        def.setEnabled(!def.isEnabled());
                        AlertSetting setting = AlertSetting.get(false);
                        String previousAuditContent = VersionedDocument.fromBean((Object)setting).toXML();
                        setting.updateDefinition(def, setting.getDefintionIndex(def.getName()));
                        setting.save();
                        AuditManager.instance.audit("Administration::Plugin", "Alert setting was modified.", VersionedDocument.fromBean((Object)setting).toXML(), previousAuditContent);
                        this.send((IEventSink)AlertDefinitionView.this.getParent(), Broadcast.EXACT, new PanelModeChanged(target, AlertDefinitionPanel.PanelMode.VIEW));
                    }
                };
                WebMarkupContainer icon = new WebMarkupContainer("icon");
                icon.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)(def.isEnabled() ? "enabled" : "disabled")))});
                icon.add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)(def.isEnabled() ? "Enabled" : "Disabled")))});
                link.add(new Component[]{icon});
                frag.add(new Component[]{link});
                item.add(new Component[]{frag});
            }

            public String getCssClass() {
                return "enum";
            }
        });
        columns.add(new AbstractColumn<AlertDefinition>((IModel)Model.of((Serializable)((Object)"Name")), "name"){

            public void populateItem(Item<ICellPopulator<AlertDefinition>> item, String id, IModel<AlertDefinition> rowModel) {
                item.add(new Component[]{new Label(id, ((AlertDefinition)rowModel.getObject()).getName())});
            }

            public String getCssClass() {
                return "nowrap-text";
            }
        });
        columns.add(new AbstractColumn<AlertDefinition>((IModel)Model.of((Serializable)((Object)"On Nodes"))){

            public void populateItem(Item<ICellPopulator<AlertDefinition>> cellItem, String componentId, IModel<AlertDefinition> rowModel) {
                AlertDefinition def = (AlertDefinition)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, def.getNodeMatcher().toHtml()).setEscapeModelStrings(false)});
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<AlertDefinition>((IModel)Model.of((Serializable)((Object)"Condition Test"))){

            public void populateItem(Item<ICellPopulator<AlertDefinition>> cellItem, String componentId, IModel<AlertDefinition> rowModel) {
                AlertCondition<?, ?> condition = ((AlertDefinition)rowModel.getObject()).getCondition();
                cellItem.add(new Component[]{new Label(componentId, condition.toString()).setEscapeModelStrings(true)});
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<AlertDefinition>((IModel)Model.of((Serializable)((Object)"Firing Strategy"))){

            public void populateItem(Item<ICellPopulator<AlertDefinition>> item, String id, IModel<AlertDefinition> rowModel) {
                AlertFiringStrategy strategy = ((AlertDefinition)rowModel.getObject()).getFiringStrategy();
                item.add(new Component[]{new Label(id, strategy.toString())});
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<AlertDefinition>((IModel)Model.of((Serializable)((Object)"Actions"))){

            public void populateItem(Item<ICellPopulator<AlertDefinition>> item, String componentId, final IModel<AlertDefinition> rowModel) {
                Fragment frag = new Fragment(componentId, "opfrag", (MarkupContainer)AlertDefinitionView.this);
                item.add(new Component[]{frag});
                frag.add(new Component[]{new AjaxLink<Void>("edit"){

                    public void onClick(AjaxRequestTarget target) {
                        AlertDefinition def = (AlertDefinition)rowModel.getObject();
                        PanelModeChanged event = new PanelModeChanged(target, AlertDefinitionPanel.PanelMode.EDIT);
                        event.setDefinition(def);
                        this.send((IEventSink)AlertDefinitionView.this.getParent(), Broadcast.EXACT, event);
                    }
                }});
                frag.add(new Component[]{new AjaxLink<Void>("remove"){

                    public void onClick(AjaxRequestTarget target) {
                        AlertSetting setting = AlertSetting.get(false);
                        String previousAuditContent = VersionedDocument.fromBean((Object)setting).toXML();
                        setting.removeDefinition((AlertDefinition)rowModel.getObject());
                        setting.save();
                        AuditManager.instance.audit("Administration::Plugin", "Alert setting was modified.", VersionedDocument.fromBean((Object)setting).toXML(), previousAuditContent);
                        this.send((IEventSink)AlertDefinitionView.this.getParent(), Broadcast.EXACT, new PanelModeChanged(target, AlertDefinitionPanel.PanelMode.VIEW));
                    }
                }.add(new Behavior[]{new ConfirmBehavior("Are you sure you want to delete this definition?")})});
            }
        });
        DataTable dataTable = new DataTable("defs", (List)columns, (IDataProvider)new AlertDefProvider(), Integer.MAX_VALUE);
        dataTable.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar(dataTable, (ISortStateLocator)((ISortableDataProvider)dataTable.getDataProvider())));
        dataTable.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar(dataTable, (IModel)Model.of((Serializable)((Object)"No Alert Definition Found"))));
        this.add(new Component[]{dataTable});
        this.add(new Component[]{new AjaxLink<Void>("addlink"){

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)AlertDefinitionView.this.getParent(), Broadcast.EXACT, new PanelModeChanged(target, AlertDefinitionPanel.PanelMode.EDIT));
            }
        }});
        this.add(new Component[]{new Link<Void>("enableLink"){

            public void onClick() {
                AlertDefinitionView.this.onSelectionAction(Action.ENABLED);
            }
        }});
        this.add(new Component[]{new Link<Void>("disableLink"){

            public void onClick() {
                AlertDefinitionView.this.onSelectionAction(Action.DISABLED);
            }
        }});
        this.add(new Component[]{new Link<Void>("removeLink"){

            public void onClick() {
                AlertDefinitionView.this.onSelectionAction(Action.REMOVED);
            }
        }.add(new Behavior[]{new ConfirmBehavior("Are you sure you want to remove the selected defintions?")})});
    }

    private void onSelectionAction(Action action) {
        Set set = this.selectionColumn.getSelections();
        if (set.isEmpty()) {
            return;
        }
        AlertSetting setting = AlertSetting.get(false);
        String previousAuditContent = VersionedDocument.fromBean((Object)setting).toXML();
        for (AlertDefinition each : set) {
            switch (action) {
                case ENABLED: {
                    each.setEnabled(true);
                    setting.updateDefinition(each, setting.getDefintionIndex(each.getName()));
                    break;
                }
                case DISABLED: {
                    each.setEnabled(false);
                    setting.updateDefinition(each, setting.getDefintionIndex(each.getName()));
                    break;
                }
                case REMOVED: {
                    setting.removeDefinition(each);
                }
            }
        }
        setting.save();
        AuditManager.instance.audit("Administration::Plugin", "Alert setting was modified.", VersionedDocument.fromBean((Object)setting).toXML(), previousAuditContent);
        this.selectionColumn.getSelections().clear();
        this.getSession().info((Serializable)((Object)("Select definitions are " + action.name().toLowerCase())));
    }

    private class AlertDefProvider
    extends ListDataProvider<AlertDefinition> {
        public AlertDefProvider() {
            super(new ArrayList());
        }

        @Override
        protected List<AlertDefinition> getList() {
            AlertSetting setting = AlertSetting.get(false);
            return setting.getDefinitions();
        }
    }

    static enum Action {
        ENABLED,
        DISABLED,
        REMOVED;

    }
}

