/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.setting;

import com.google.common.base.Objects;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertDefinition;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertDefinitionPanel;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertSetting;
import com.pmease.quickbuild.plugin.alert.engine.setting.ConditionEditor;
import com.pmease.quickbuild.plugin.alert.engine.setting.ConditionEditorCreator;
import com.pmease.quickbuild.plugin.alert.engine.setting.PanelModeChanged;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class AlertDefinitionEditor
extends Panel {
    private final AlertDefinition definition;
    private String oldName;

    public AlertDefinitionEditor(String id, AlertDefinition definition) {
        super(id);
        this.definition = definition;
        this.oldName = definition.getName();
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        Form form = new Form("form");
        this.add(new Component[]{form});
        form.add(new Component[]{new FeedbackPanel("feedback", (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter((Component)form))});
        final EditContext basicContext = new EditContext((Object)this.definition, new String[]{"firingStrategy"}, true);
        BeanEditor basicEditor = new BeanEditor("basic", basicContext);
        form.add(new Component[]{basicEditor});
        final EditContext strategyContext = new EditContext((Object)this.definition, new String[]{"firingStrategy"}, false);
        BeanEditor strategyEditor = new BeanEditor("strategy", strategyContext);
        form.add(new Component[]{strategyEditor});
        ConditionEditorCreator creator = (ConditionEditorCreator)PluginManager.instance.getExtensions(ConditionEditorCreator.class).get(0);
        final ConditionEditor conditionEditor = creator.createEditor("condition", (IModel<AlertDefinition>)Model.of((Serializable)this.definition), form);
        form.add(new Component[]{conditionEditor});
        form.add(new Component[]{new AjaxButton("submit", form){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                basicContext.validate(false);
                strategyContext.validate(false);
                if (basicContext.hasError() || strategyContext.hasError()) {
                    form.error((Serializable)((Object)"Please fix below errors"));
                    target.add(new Component[]{form});
                    return;
                }
                if (!conditionEditor.onSubmit(target, form)) {
                    return;
                }
                basicContext.update((Object)AlertDefinitionEditor.this.definition);
                strategyContext.update((Object)AlertDefinitionEditor.this.definition);
                AlertSetting setting = AlertSetting.get(false);
                if (!Objects.equal((Object)AlertDefinitionEditor.this.oldName, (Object)AlertDefinitionEditor.this.definition.getName()) && setting.hasName(AlertDefinitionEditor.this.definition.getName())) {
                    basicContext.getProperty("name").setError("The definition name is already used, please choose another name.");
                    target.add(new Component[]{form});
                    return;
                }
                int index = setting.getDefintionIndex(AlertDefinitionEditor.this.oldName);
                String previousAuditContent = VersionedDocument.fromBean((Object)setting).toXML();
                setting.updateDefinition(AlertDefinitionEditor.this.definition, index);
                setting.save();
                AuditManager.instance.audit("Administration::Plugin", "Alert setting was modified.", VersionedDocument.fromBean((Object)setting).toXML(), previousAuditContent);
                this.send((IEventSink)AlertDefinitionEditor.this.getParent(), Broadcast.EXACT, new PanelModeChanged(target, AlertDefinitionPanel.PanelMode.VIEW));
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                if (target != null) {
                    form.error((Serializable)((Object)"Please fix below errors"));
                    target.add(new Component[]{form});
                }
            }
        }});
        form.add(new Component[]{new AjaxLink<Void>("cancel"){

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)AlertDefinitionEditor.this.getParent(), Broadcast.EXACT, new PanelModeChanged(target, AlertDefinitionPanel.PanelMode.VIEW));
            }
        }});
    }
}

