/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.setting;

import com.google.common.base.Objects;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.plugin.alert.engine.condition.AlertCondition;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.AnyNodeMatcher;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;
import com.pmease.quickbuild.plugin.alert.engine.strategy.AlertFiringStrategy;
import com.pmease.quickbuild.plugin.alert.engine.strategy.EachStrategy;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi
public class AlertDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Alert.AlertPriority priority = Alert.AlertPriority.MEDIUM;
    private boolean enabled = true;
    private NodeMatcher nodeMatcher = new AnyNodeMatcher();
    private AlertCondition<?, ?> condition;
    private AlertFiringStrategy firingStrategy = new EachStrategy();

    @Editable(name="Name", order=100, description="The name should be unique in your alert definitions")
    @NotEmpty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(name="Priority", order=200)
    @NotNull
    public Alert.AlertPriority getPriority() {
        return this.priority;
    }

    public void setPriority(Alert.AlertPriority priority) {
        this.priority = priority;
    }

    @Editable(name="Node", order=300)
    @NotNull
    public NodeMatcher getNodeMatcher() {
        return this.nodeMatcher;
    }

    public void setNodeMatcher(NodeMatcher nodeMatcher) {
        this.nodeMatcher = nodeMatcher;
    }

    public AlertCondition<?, ?> getCondition() {
        return this.condition;
    }

    public void setCondition(AlertCondition<?, ?> condition) {
        this.condition = condition;
    }

    @Editable(name="Firing Strategy", order=500, description="Specifies the strategy for firing an alert. QuickBuild collects the measurement data from each node every five minutes and then check the condition set specified above, if the condition set test is true, an alert can be fired based on your strategy defined here.")
    @NotNull
    public AlertFiringStrategy getFiringStrategy() {
        return this.firingStrategy;
    }

    public void setFiringStrategy(AlertFiringStrategy firingStrategy) {
        this.firingStrategy = firingStrategy;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AlertDefinition)) {
            return false;
        }
        AlertDefinition rhs = (AlertDefinition)other;
        return Objects.equal((Object)this.name, (Object)rhs.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name).append(": ").append(this.priority).append(", ").append(this.enabled ? "enabled" : "disabled").append(", ").append("condition [").append(this.condition.toString()).append("]");
        return sb.toString();
    }
}

