/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.setting;

import com.pmease.quickbuild.entitymanager.AlarmManager;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Alarm;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertSettingBean;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;

public class AlarmEditor
extends Panel {
    public AlarmEditor(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        final AlertSettingBean bean = new AlertSettingBean();
        bean.setAlarms(AlarmManager.instance.getAll());
        final String previousAlarmSettingContent = VersionedDocument.fromBean((Object)bean).toXML();
        final EditContext editContext = new EditContext((Object)bean);
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    editContext.update((Object)bean);
                    for (Alarm alarm : AlarmManager.instance.getAll()) {
                        AlarmManager.instance.delete((AbstractEntity)alarm);
                    }
                    for (Alarm alarm : bean.getAlarms()) {
                        alarm.setId(null);
                        AlarmManager.instance.save((AbstractEntity)alarm);
                    }
                    AuditManager.instance.audit("Administration::Alarm Setting", "Alarm setting was modified.", VersionedDocument.fromBean((Object)bean).toXML(), previousAlarmSettingContent);
                    this.getSession().info((Serializable)((Object)"Alarm setting has been updated."));
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("alarmSettingEditor", editContext)});
        this.add(new Component[]{form});
    }
}

