/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.rest;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.AlertManager;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.security.SecurityHelper;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

@Path(value="/alerts")
public class AlertRest {
    @GET
    public List<Alert> getAlerts(@QueryParam(value="fromId") Long fromId, @QueryParam(value="toId") Long toId, @QueryParam(value="priority") String priority, @QueryParam(value="trigger") String trigger, @QueryParam(value="subject") String subject, @QueryParam(value="fromTime") Long fromTime, @QueryParam(value="toTime") Long toTime) {
        if (!SecurityHelper.isViewAlertsAllowed()) {
            throw AlertRest.buildException(Response.Status.FORBIDDEN.getStatusCode(), "User " + Context.getUser() + " MUST has view alerts permission");
        }
        SearchCriteria.Builder builder = SearchCriteria.builder();
        if (fromId != null) {
            builder.add((Criterion)Restrictions.ge((String)"id", (Object)fromId));
        }
        if (toId != null) {
            builder.add((Criterion)Restrictions.lt((String)"id", (Object)toId));
        }
        if (priority != null) {
            builder.add((Criterion)Restrictions.eq((String)"priority", (Object)Alert.AlertPriority.valueOf((String)priority)));
        }
        if (trigger != null) {
            builder.add((Criterion)Restrictions.eq((String)"trigger", (Object)trigger));
        }
        if (subject != null) {
            builder.add((Criterion)Restrictions.eq((String)"subject", (Object)subject));
        }
        if (fromTime != null) {
            builder.add((Criterion)Restrictions.ge((String)"ctime", (Object)fromTime));
        }
        if (toTime != null) {
            builder.add((Criterion)Restrictions.le((String)"ctime", (Object)toTime));
        }
        builder.add(Order.desc((String)"ctime"));
        return AlertManager.instance.search(builder.build(), 0, 0);
    }

    protected static WebApplicationException buildException(int status, String msg) {
        return new WebApplicationException(Response.status((int)status).entity((Object)msg).type("text/plain").build());
    }
}

