/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.nodematcher;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcherCriteria;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="Nodes matching one of specified criterias", order=220)
public class OrMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private List<NodeMatcherCriteria> criterias;

    public static OrMatcher of(NodeMatcher ... matchers) {
        ArrayList list = Lists.newArrayList();
        for (NodeMatcher each : matchers) {
            if (each == null) continue;
            list.add(new NodeMatcherCriteria(each));
        }
        return new OrMatcher(list);
    }

    public OrMatcher() {
    }

    public OrMatcher(List<NodeMatcherCriteria> criterias) {
        this.criterias = criterias;
    }

    @Editable
    @Size(min=2, max=100)
    public List<NodeMatcherCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<NodeMatcherCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public boolean matches(GridNode node) {
        for (NodeMatcherCriteria each : this.getCriterias()) {
            if (!each.getCriteria().matches(node)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OrMatcher)) {
            return false;
        }
        OrMatcher rhs = (OrMatcher)other;
        return Objects.equal(this.criterias, rhs.criterias);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.criterias});
    }

    public String toString() {
        ArrayList list = Lists.newArrayList();
        for (NodeMatcherCriteria each : this.criterias) {
            boolean b;
            StringBuffer sb = new StringBuffer();
            boolean bl = b = this.criterias.size() > 0;
            if (b) {
                sb.append("(");
            }
            sb.append(each.toString());
            if (b) {
                sb.append(")");
            }
            list.add(sb.toString());
        }
        return Joiner.on((String)" or ").join((Iterable)list);
    }

    @Override
    public String getName() {
        return "OR";
    }

    @Override
    public String toHtml() {
        boolean b;
        StringBuffer sb = new StringBuffer();
        boolean bl = b = this.criterias.size() > 1;
        if (b) {
            sb.append("<ul class='square'>");
        }
        int i = 0;
        for (NodeMatcherCriteria each : this.criterias) {
            if (b) {
                sb.append("<li>");
            }
            sb.append("<span>").append(each.toHtml()).append("</span>");
            if (i + 1 < this.criterias.size()) {
                sb.append("<span> or </span>");
            }
            if (b) {
                sb.append("</li>");
            }
            ++i;
        }
        if (b) {
            sb.append("</ul>");
        }
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        for (NodeMatcherCriteria each : this.criterias) {
            if (each.isValid()) continue;
            return false;
        }
        return true;
    }
}

