/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.nodematcher;

import com.google.common.base.Objects;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;
import javax.validation.constraints.NotNull;

@Editable(name="Nodes not matching specified criteria", order=224)
public class NotMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private NodeMatcher criteria;

    @Editable
    @NotNull
    public NodeMatcher getCriteria() {
        return this.criteria;
    }

    public void setCriteria(NodeMatcher criteria) {
        this.criteria = criteria;
    }

    @Override
    public boolean matches(GridNode node) {
        return !this.criteria.matches(node);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotMatcher)) {
            return false;
        }
        NotMatcher rhs = (NotMatcher)other;
        return Objects.equal((Object)this.criteria, (Object)rhs.criteria);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.criteria});
    }

    public String toString() {
        return "Not [" + this.criteria + "]";
    }

    @Override
    public String getName() {
        return "NOT";
    }

    @Override
    public String toHtml() {
        return "<b>NOT</b> " + this.criteria.toHtml();
    }

    @Override
    public boolean isValid() {
        return this.criteria.isValid();
    }
}

