/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.nodematcher;

import com.google.common.base.Strings;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;
import org.apache.commons.net.util.SubnetUtils;

@Editable(name="All nodes in the specified subnet", order=500)
public class NodeInSubnetMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private String subnet;

    @Override
    public String getName() {
        return "Node in Subnet";
    }

    @Override
    public String toHtml() {
        return "in subnet " + this.subnet;
    }

    @Editable(name="Subnet in CIDR format", order=100, description="Specify the subnet in CIDR format, for example: 192.168.10.0/16")
    public String getSubnet() {
        return this.subnet;
    }

    public void setSubnet(String subnet) {
        this.subnet = subnet;
    }

    @Override
    public boolean matches(GridNode node) {
        SubnetUtils utils = new SubnetUtils(this.subnet);
        return utils.getInfo().isInRange(node.getIp());
    }

    public static void main(String[] args) {
        SubnetUtils utils = new SubnetUtils("192.168.0.0/16");
        System.out.println("lower address: " + utils.getInfo().getLowAddress());
        System.out.println("higher address: " + utils.getInfo().getHighAddress());
        System.out.println("192.168.255.254 is in range? :" + utils.getInfo().isInRange("192.168.255.254"));
    }

    @Override
    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.subnet);
    }
}

