/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.nodematcher;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;
import java.util.regex.Pattern;

@Editable(name="Node name matches specified pattern", order=200)
public class NameRegexMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private String pattern;

    @Override
    public boolean matches(GridNode node) {
        if (Strings.isNullOrEmpty((String)this.pattern)) {
            return true;
        }
        return Pattern.matches(this.getPattern(), node.getAddress());
    }

    @Editable(name="Regex pattern")
    @Scriptable
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pattern});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NameRegexMatcher)) {
            return false;
        }
        NameRegexMatcher rhs = (NameRegexMatcher)other;
        return Objects.equal((Object)this.pattern, (Object)rhs.pattern);
    }

    public String toString() {
        return "name match pattern [" + this.getPattern() + "]";
    }

    @Override
    public String getName() {
        return "NAME_REGEX";
    }

    @Override
    public String toHtml() {
        return "name match <code>" + this.getPattern() + "</code>";
    }

    @Override
    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.pattern);
    }
}

