/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.nodematcher;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;

@Editable(name="Name contains specified pattern", order=180)
public class NameContainsMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private String pattern;

    public NameContainsMatcher() {
    }

    public NameContainsMatcher(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean matches(GridNode node) {
        if (Strings.isNullOrEmpty((String)this.getPattern())) {
            return true;
        }
        return node.getAddress().toLowerCase().contains(this.getPattern().toLowerCase());
    }

    @Editable(name="Pattern")
    @Scriptable
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pattern});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NameContainsMatcher)) {
            return false;
        }
        NameContainsMatcher rhs = (NameContainsMatcher)other;
        return Objects.equal((Object)this.pattern, (Object)rhs.pattern);
    }

    public String toString() {
        return "name contains [" + this.getPattern() + "]";
    }

    @Override
    public String getName() {
        return "NAME_CONTAINS";
    }

    @Override
    public String toHtml() {
        return "name contains <code>" + this.getPattern() + "</code>";
    }

    @Override
    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.pattern);
    }
}

