/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.nodematcher;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="On node with specified resource", order=15)
public class HasResourceMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private String resource;

    public HasResourceMatcher() {
    }

    public HasResourceMatcher(String resource) {
        this.resource = resource;
    }

    @Override
    public boolean matches(GridNode node) {
        Resource resource = Quickbuild.getServerService().getResource(this.getResource());
        if (resource == null) {
            return false;
        }
        return resource.getCount(node) > 0;
    }

    @Editable(name="Resource")
    @NotEmpty
    @Scriptable
    @ExpressionProvider(value="getResourceChoices")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    private static Map<String, String> getResourceChoices() {
        LinkedHashMap<String, String> choices = new LinkedHashMap<String, String>();
        List resources = CacheManager.instance.getResources();
        Collections.sort(resources, new Comparator<Resource>(){

            @Override
            public int compare(Resource r1, Resource r2) {
                return r1.getName().compareTo(r2.getName());
            }
        });
        for (Resource resource : resources) {
            choices.put(resource.getName(), resource.getName());
        }
        return choices;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HasResourceMatcher)) {
            return false;
        }
        HasResourceMatcher rhs = (HasResourceMatcher)other;
        return Objects.equal((Object)this.resource, (Object)rhs.resource);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.resource});
    }

    public String toString() {
        return "has resource [" + this.getResource() + "]";
    }

    @Override
    public String getName() {
        return "HAS_RESOURCE";
    }

    @Override
    public String toHtml() {
        return "has resource <code>" + this.getResource() + "</code>";
    }

    @Override
    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.resource);
    }
}

